/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common;

import ai.timefold.solver.core.config.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ReachableValues {
    private final Map<Object, ReachableItemValue> values;
    private final @Nullable Class<?> valueClass;
    private final boolean acceptsNullValue;
    private @Nullable ReachableItemValue firstCachedObject;
    private @Nullable ReachableItemValue secondCachedObject;

    public ReachableValues(Map<Object, ReachableItemValue> values, Class<?> valueClass, boolean acceptsNullValue) {
        this.values = values;
        this.valueClass = valueClass;
        this.acceptsNullValue = acceptsNullValue;
    }

    private @Nullable ReachableItemValue fetchItemValue(Object value) {
        ReachableItemValue selected = null;
        if (this.firstCachedObject != null && this.firstCachedObject.value == value) {
            selected = this.firstCachedObject;
        } else if (this.secondCachedObject != null && this.secondCachedObject.value == value) {
            selected = this.secondCachedObject;
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        if (selected == null) {
            selected = this.values.get(value);
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        return selected;
    }

    public List<Object> extractEntitiesAsList(Object value) {
        ReachableItemValue itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        return itemValue.randomAccessEntityList;
    }

    public List<Object> extractValuesAsList(Object value) {
        ReachableItemValue itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        return itemValue.randomAccessValueList;
    }

    public int getSize() {
        return this.values.size();
    }

    public boolean isEntityReachable(@Nullable Object origin, @Nullable Object entity) {
        if (entity == null) {
            return true;
        }
        if (origin == null) {
            return this.acceptsNullValue;
        }
        ReachableItemValue originItemValue = this.fetchItemValue(origin);
        if (originItemValue == null) {
            return false;
        }
        return originItemValue.entityMap.containsKey(entity);
    }

    public boolean isValueReachable(Object origin, @Nullable Object otherValue) {
        ReachableItemValue originItemValue = this.fetchItemValue(Objects.requireNonNull(origin));
        if (originItemValue == null) {
            return false;
        }
        if (otherValue == null) {
            return this.acceptsNullValue;
        }
        return originItemValue.valueMap.containsKey(Objects.requireNonNull(otherValue));
    }

    public boolean matchesValueClass(Object value) {
        return this.valueClass != null && this.valueClass.isAssignableFrom(Objects.requireNonNull(value).getClass());
    }

    @NullMarked
    public static final class ReachableItemValue {
        private final Object value;
        private final Map<Object, Object> entityMap;
        private final Map<Object, Object> valueMap;
        private final List<Object> randomAccessEntityList;
        private final List<Object> randomAccessValueList;

        public ReachableItemValue(Object value, int entityListSize, int valueListSize) {
            this.value = value;
            this.entityMap = new IdentityHashMap<Object, Object>(entityListSize);
            this.randomAccessEntityList = new ArrayList<Object>(entityListSize);
            this.valueMap = ConfigUtils.isGenericTypeImmutable(value.getClass()) ? new LinkedHashMap(valueListSize) : new IdentityHashMap(valueListSize);
            this.randomAccessValueList = new ArrayList<Object>(valueListSize);
        }

        public void addEntity(Object entity) {
            if (this.entityMap.put(entity, entity) == null) {
                this.randomAccessEntityList.add(entity);
            }
        }

        public void addValue(Object value) {
            if (this.valueMap.put(value, value) == null) {
                this.randomAccessValueList.add(value);
            }
        }
    }
}

