/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic;

import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.SubListMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.impl.solver.thread.DefaultSolverThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadFactory;

public class HeuristicConfigPolicy<Solution_> {
    private final Set<PreviewFeature> previewFeatureSet;
    private final EnvironmentMode environmentMode;
    private final String logIndentation;
    private final Integer moveThreadCount;
    private final Integer moveThreadBufferSize;
    private final Class<? extends ThreadFactory> threadFactoryClass;
    private final InitializingScoreTrend initializingScoreTrend;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final EntitySorterManner entitySorterManner;
    private final ValueSorterManner valueSorterManner;
    private final ClassInstanceCache classInstanceCache;
    private final boolean reinitializeVariableFilterEnabled;
    private final boolean initializedChainedValueFilterEnabled;
    private final boolean unassignedValuesAllowed;
    private final Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass;
    private final Random random;
    private final Map<String, EntityMimicRecorder<Solution_>> entityMimicRecorderMap = new HashMap<String, EntityMimicRecorder<Solution_>>();
    private final Map<String, SubListMimicRecorder<Solution_>> subListMimicRecorderMap = new HashMap<String, SubListMimicRecorder<Solution_>>();
    private final Map<String, ValueMimicRecorder<Solution_>> valueMimicRecorderMap = new HashMap<String, ValueMimicRecorder<Solution_>>();

    private HeuristicConfigPolicy(Builder<Solution_> builder) {
        this.previewFeatureSet = builder.previewFeatureSet;
        this.environmentMode = builder.environmentMode;
        this.logIndentation = builder.logIndentation;
        this.moveThreadCount = builder.moveThreadCount;
        this.moveThreadBufferSize = builder.moveThreadBufferSize;
        this.threadFactoryClass = builder.threadFactoryClass;
        this.initializingScoreTrend = builder.initializingScoreTrend;
        this.solutionDescriptor = builder.solutionDescriptor;
        this.entitySorterManner = builder.entitySorterManner;
        this.valueSorterManner = builder.valueSorterManner;
        this.classInstanceCache = builder.classInstanceCache;
        this.reinitializeVariableFilterEnabled = builder.reinitializeVariableFilterEnabled;
        this.initializedChainedValueFilterEnabled = builder.initializedChainedValueFilterEnabled;
        this.unassignedValuesAllowed = builder.unassignedValuesAllowed;
        this.nearbyDistanceMeterClass = builder.nearbyDistanceMeterClass;
        this.random = builder.random;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public String getLogIndentation() {
        return this.logIndentation;
    }

    public Integer getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public Integer getMoveThreadBufferSize() {
        return this.moveThreadBufferSize;
    }

    public InitializingScoreTrend getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solutionDescriptor.getScoreDefinition();
    }

    public EntitySorterManner getEntitySorterManner() {
        return this.entitySorterManner;
    }

    public ValueSorterManner getValueSorterManner() {
        return this.valueSorterManner;
    }

    public ClassInstanceCache getClassInstanceCache() {
        return this.classInstanceCache;
    }

    public boolean isReinitializeVariableFilterEnabled() {
        return this.reinitializeVariableFilterEnabled;
    }

    public boolean isInitializedChainedValueFilterEnabled() {
        return this.initializedChainedValueFilterEnabled;
    }

    public boolean isUnassignedValuesAllowed() {
        return this.unassignedValuesAllowed;
    }

    public Class<? extends NearbyDistanceMeter> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public Random getRandom() {
        return this.random;
    }

    public Builder<Solution_> cloneBuilder() {
        return new Builder().withPreviewFeatureSet(this.previewFeatureSet).withEnvironmentMode(this.environmentMode).withMoveThreadCount(this.moveThreadCount).withMoveThreadBufferSize(this.moveThreadBufferSize).withThreadFactoryClass(this.threadFactoryClass).withNearbyDistanceMeterClass(this.nearbyDistanceMeterClass).withRandom(this.random).withInitializingScoreTrend(this.initializingScoreTrend).withSolutionDescriptor(this.solutionDescriptor).withClassInstanceCache(this.classInstanceCache).withLogIndentation(this.logIndentation);
    }

    public HeuristicConfigPolicy<Solution_> copyConfigPolicy() {
        return this.cloneBuilder().withEntitySorterManner(this.entitySorterManner).withValueSorterManner(this.valueSorterManner).withReinitializeVariableFilterEnabled(this.reinitializeVariableFilterEnabled).withInitializedChainedValueFilterEnabled(this.initializedChainedValueFilterEnabled).withUnassignedValuesAllowed(this.unassignedValuesAllowed).build();
    }

    public HeuristicConfigPolicy<Solution_> createPhaseConfigPolicy() {
        return this.cloneBuilder().build();
    }

    public HeuristicConfigPolicy<Solution_> copyConfigPolicyWithoutNearbySetting() {
        return this.cloneBuilder().withNearbyDistanceMeterClass(null).build();
    }

    public HeuristicConfigPolicy<Solution_> createChildThreadConfigPolicy(ChildThreadType childThreadType) {
        return this.cloneBuilder().withLogIndentation(this.logIndentation + "        ").build();
    }

    public void addEntityMimicRecorder(String id, EntityMimicRecorder<Solution_> mimicRecordingEntitySelector) {
        EntityMimicRecorder<Solution_> put = this.entityMimicRecorderMap.put(id, mimicRecordingEntitySelector);
        if (put != null) {
            throw new IllegalStateException("Multiple %ss (usually %ss) have the same id (%s).\nMaybe specify a variable name for the mimicking selector in situations with multiple variables on the same entity?".formatted(EntityMimicRecorder.class.getSimpleName(), EntitySelector.class.getSimpleName(), id));
        }
    }

    public EntityMimicRecorder<Solution_> getEntityMimicRecorder(String id) {
        return this.entityMimicRecorderMap.get(id);
    }

    public void addSubListMimicRecorder(String id, SubListMimicRecorder<Solution_> mimicRecordingSubListSelector) {
        SubListMimicRecorder<Solution_> put = this.subListMimicRecorderMap.put(id, mimicRecordingSubListSelector);
        if (put != null) {
            throw new IllegalStateException("Multiple %ss (usually %ss) have the same id (%s).\nMaybe specify a variable name for the mimicking selector in situations with multiple variables on the same entity?".formatted(SubListMimicRecorder.class.getSimpleName(), SubListSelector.class.getSimpleName(), id));
        }
    }

    public SubListMimicRecorder<Solution_> getSubListMimicRecorder(String id) {
        return this.subListMimicRecorderMap.get(id);
    }

    public void addValueMimicRecorder(String id, ValueMimicRecorder<Solution_> mimicRecordingValueSelector) {
        ValueMimicRecorder<Solution_> put = this.valueMimicRecorderMap.put(id, mimicRecordingValueSelector);
        if (put != null) {
            throw new IllegalStateException("Multiple %ss (usually %ss) have the same id (%s).\nMaybe specify a variable name for the mimicking selector in situations with multiple variables on the same entity?".formatted(ValueMimicRecorder.class.getSimpleName(), ValueSelector.class.getSimpleName(), id));
        }
    }

    public ValueMimicRecorder<Solution_> getValueMimicRecorder(String id) {
        return this.valueMimicRecorderMap.get(id);
    }

    public ThreadFactory buildThreadFactory(ChildThreadType childThreadType) {
        if (this.threadFactoryClass != null) {
            return ConfigUtils.newInstance(this::toString, "threadFactoryClass", this.threadFactoryClass);
        }
        String threadPrefix = switch (childThreadType) {
            default -> throw new IncompatibleClassChangeError();
            case ChildThreadType.MOVE_THREAD -> "MoveThread";
            case ChildThreadType.PART_THREAD -> "PartThread";
        };
        return new DefaultSolverThreadFactory(threadPrefix);
    }

    public void ensurePreviewFeature(PreviewFeature previewFeature) {
        HeuristicConfigPolicy.ensurePreviewFeature(previewFeature, this.previewFeatureSet);
    }

    public static void ensurePreviewFeature(PreviewFeature previewFeature, Collection<PreviewFeature> previewFeatureCollection) {
        if (previewFeatureCollection == null || !previewFeatureCollection.contains((Object)previewFeature)) {
            throw new IllegalStateException("The preview feature %s is not enabled.\nMaybe add %s to <enablePreviewFeature> in your configuration file?".formatted(new Object[]{previewFeature, previewFeature}));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this.environmentMode) + ")";
    }

    public static class Builder<Solution_> {
        private Set<PreviewFeature> previewFeatureSet;
        private EnvironmentMode environmentMode;
        private Integer moveThreadCount;
        private Integer moveThreadBufferSize;
        private Class<? extends ThreadFactory> threadFactoryClass;
        private InitializingScoreTrend initializingScoreTrend;
        private SolutionDescriptor<Solution_> solutionDescriptor;
        private ClassInstanceCache classInstanceCache;
        private String logIndentation = "";
        private EntitySorterManner entitySorterManner = EntitySorterManner.NONE;
        private ValueSorterManner valueSorterManner = ValueSorterManner.NONE;
        private boolean reinitializeVariableFilterEnabled = false;
        private boolean initializedChainedValueFilterEnabled = false;
        private boolean unassignedValuesAllowed = false;
        private Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass;
        private Random random;

        public Builder<Solution_> withPreviewFeatureSet(Set<PreviewFeature> previewFeatureSet) {
            this.previewFeatureSet = previewFeatureSet;
            return this;
        }

        public Builder<Solution_> withEnvironmentMode(EnvironmentMode environmentMode) {
            this.environmentMode = environmentMode;
            return this;
        }

        public Builder<Solution_> withMoveThreadCount(Integer moveThreadCount) {
            this.moveThreadCount = moveThreadCount;
            return this;
        }

        public Builder<Solution_> withMoveThreadBufferSize(Integer moveThreadBufferSize) {
            this.moveThreadBufferSize = moveThreadBufferSize;
            return this;
        }

        public Builder<Solution_> withThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
            this.threadFactoryClass = threadFactoryClass;
            return this;
        }

        public Builder<Solution_> withNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass) {
            this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
            return this;
        }

        public Builder<Solution_> withRandom(Random random) {
            this.random = random;
            return this;
        }

        public Builder<Solution_> withInitializingScoreTrend(InitializingScoreTrend initializingScoreTrend) {
            this.initializingScoreTrend = initializingScoreTrend;
            return this;
        }

        public Builder<Solution_> withSolutionDescriptor(SolutionDescriptor<Solution_> solutionDescriptor) {
            this.solutionDescriptor = solutionDescriptor;
            return this;
        }

        public Builder<Solution_> withClassInstanceCache(ClassInstanceCache classInstanceCache) {
            this.classInstanceCache = classInstanceCache;
            return this;
        }

        public Builder<Solution_> withLogIndentation(String logIndentation) {
            this.logIndentation = logIndentation;
            return this;
        }

        public Builder<Solution_> withEntitySorterManner(EntitySorterManner entitySorterManner) {
            this.entitySorterManner = entitySorterManner;
            return this;
        }

        public Builder<Solution_> withValueSorterManner(ValueSorterManner valueSorterManner) {
            this.valueSorterManner = valueSorterManner;
            return this;
        }

        public Builder<Solution_> withReinitializeVariableFilterEnabled(boolean reinitializeVariableFilterEnabled) {
            this.reinitializeVariableFilterEnabled = reinitializeVariableFilterEnabled;
            return this;
        }

        public Builder<Solution_> withInitializedChainedValueFilterEnabled(boolean initializedChainedValueFilterEnabled) {
            this.initializedChainedValueFilterEnabled = initializedChainedValueFilterEnabled;
            return this;
        }

        public Builder<Solution_> withUnassignedValuesAllowed(boolean unassignedValuesAllowed) {
            this.unassignedValuesAllowed = unassignedValuesAllowed;
            return this;
        }

        public HeuristicConfigPolicy<Solution_> build() {
            return new HeuristicConfigPolicy(this);
        }
    }
}

