/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support.violation;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableId;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class VariableSnapshotTotal<Solution_> {
    private final Map<VariableId<Solution_>, VariableSnapshot<Solution_>> variableIdToSnapshot = new HashMap<VariableId<Solution_>, VariableSnapshot<Solution_>>();

    private VariableSnapshotTotal() {
    }

    public static <Solution_> VariableSnapshotTotal<Solution_> takeSnapshot(SolutionDescriptor<Solution_> solutionDescriptor, Solution_ workingSolution) {
        VariableSnapshotTotal out = new VariableSnapshotTotal();
        solutionDescriptor.visitAllEntities(workingSolution, entity -> {
            EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                out.recordVariable(variableDescriptor, entity);
            }
        });
        return out;
    }

    private void recordVariable(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        VariableSnapshot<Solution_> snapshot = new VariableSnapshot<Solution_>(variableDescriptor, entity);
        this.variableIdToSnapshot.put(snapshot.getVariableId(), snapshot);
    }

    public List<VariableId<Solution_>> changedVariablesFrom(VariableSnapshotTotal<Solution_> before) {
        ArrayList<VariableId<Solution_>> out = new ArrayList<VariableId<Solution_>>();
        for (VariableId<Solution_> variableId : this.variableIdToSnapshot.keySet()) {
            VariableSnapshot<Solution_> variableAfter;
            VariableSnapshot<Solution_> variableBefore = before.variableIdToSnapshot.get(variableId);
            if (!variableBefore.isDifferentFrom(variableAfter = this.variableIdToSnapshot.get(variableId))) continue;
            out.add(variableAfter.getVariableId());
        }
        return out;
    }

    public VariableSnapshot<Solution_> getVariableSnapshot(VariableId<Solution_> variableId) {
        return this.variableIdToSnapshot.get(variableId);
    }

    public void restore() {
        this.variableIdToSnapshot.values().forEach(VariableSnapshot::restore);
    }
}

