/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class NotifiableRegistry<Solution_> {
    private final List<Notifiable> notifiableList = new ArrayList<Notifiable>();
    private final Set<EntityNotifiable<Solution_>>[] sourceEntityToNotifiableSetArray;
    private final List<Notifiable>[][] sourceVariableToNotifiableListArray;

    NotifiableRegistry(SolutionDescriptor<Solution_> solutionDescriptor) {
        Collection<EntityDescriptor<Solution_>> entityDescriptorList = solutionDescriptor.getEntityDescriptors();
        int entityDescriptorListSize = entityDescriptorList.size();
        this.sourceEntityToNotifiableSetArray = new Set[entityDescriptorListSize];
        this.sourceVariableToNotifiableListArray = new List[entityDescriptorListSize][];
        for (EntityDescriptor<Solution_> entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
            Collection<VariableDescriptor<Solution_>> declaredVariableDescriptorList = entityDescriptor.getDeclaredVariableDescriptors();
            List[] array = new List[declaredVariableDescriptorList.size()];
            for (VariableDescriptor<Solution_> variableDescriptor : declaredVariableDescriptorList) {
                array[variableDescriptor.getOrdinal()] = new ArrayList();
            }
            int entityDescriptorId = entityDescriptor.getOrdinal();
            this.sourceVariableToNotifiableListArray[entityDescriptorId] = array;
            this.sourceEntityToNotifiableSetArray[entityDescriptorId] = new LinkedHashSet<EntityNotifiable<Solution_>>();
        }
    }

    void registerNotifiable(VariableDescriptor<Solution_> source, EntityNotifiable<Solution_> notifiable) {
        this.registerNotifiable(Collections.singletonList(source), notifiable);
    }

    void registerNotifiable(Collection<VariableDescriptor<Solution_>> sources, EntityNotifiable<Solution_> notifiable) {
        for (VariableDescriptor<Solution_> source : sources) {
            int entityDescriptorId = source.getEntityDescriptor().getOrdinal();
            this.sourceVariableToNotifiableListArray[entityDescriptorId][source.getOrdinal()].add(notifiable);
            this.sourceEntityToNotifiableSetArray[entityDescriptorId].add(notifiable);
        }
        this.notifiableList.add(notifiable);
    }

    Iterable<Notifiable> getAll() {
        return this.notifiableList;
    }

    Collection<EntityNotifiable<Solution_>> get(EntityDescriptor<?> entityDescriptor) {
        return this.sourceEntityToNotifiableSetArray[entityDescriptor.getOrdinal()];
    }

    Collection<VariableListenerNotifiable<Solution_>> get(VariableDescriptor<?> variableDescriptor) {
        List<Notifiable> notifiables = this.sourceVariableToNotifiableListArray[variableDescriptor.getEntityDescriptor().getOrdinal()][variableDescriptor.getOrdinal()];
        if (notifiables == null) {
            return Collections.emptyList();
        }
        return notifiables;
    }

    Collection<ListVariableListenerNotifiable<Solution_>> get(ListVariableDescriptor<?> variableDescriptor) {
        List<Notifiable> notifiables = this.sourceVariableToNotifiableListArray[variableDescriptor.getEntityDescriptor().getOrdinal()][variableDescriptor.getOrdinal()];
        if (notifiables == null) {
            return Collections.emptyList();
        }
        return notifiables;
    }
}

