/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.composite;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.ValueRangeCache;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CompositeCountableValueRange<T>
extends AbstractCountableValueRange<T> {
    private final boolean isValueImmutable;
    private final ValueRangeCache<T> cache;

    public CompositeCountableValueRange(List<? extends AbstractCountableValueRange<T>> childValueRangeList) {
        long maximumSize = 0L;
        boolean isValueImmutable = true;
        for (AbstractCountableValueRange<T> childValueRange : childValueRangeList) {
            isValueImmutable &= childValueRange.isValueImmutable();
            maximumSize += childValueRange.getSize();
        }
        ValueRangeCache.Builder cacheBuilder = isValueImmutable ? ValueRangeCache.Builder.FOR_TRUSTED_VALUES : ValueRangeCache.Builder.FOR_USER_VALUES;
        this.cache = cacheBuilder.buildCache((int)maximumSize);
        for (AbstractCountableValueRange<T> childValueRange : childValueRangeList) {
            if (childValueRange instanceof NullAllowingCountableValueRange) {
                NullAllowingCountableValueRange nullAllowingCountableValueRange = (NullAllowingCountableValueRange)childValueRange;
                childValueRange = nullAllowingCountableValueRange.getChildValueRange();
            }
            childValueRange.createOriginalIterator().forEachRemaining(this.cache::add);
        }
        this.isValueImmutable = isValueImmutable;
    }

    @Override
    public boolean isValueImmutable() {
        return this.isValueImmutable;
    }

    @Override
    public long getSize() {
        return this.cache.getSize();
    }

    @Override
    public T get(long index) {
        return this.cache.get((int)index);
    }

    @Override
    public boolean contains(@Nullable T value) {
        return this.cache.contains(value);
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        return this.cache.iterator();
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return this.cache.iterator(workingRandom);
    }
}

