/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange;

import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ValueRangeCache<Value_>
implements Iterable<Value_> {
    private final List<Value_> valuesWithFastRandomAccess;
    private final Set<Value_> valuesWithFastLookup;

    private ValueRangeCache(int size, Set<Value_> emptyCacheSet) {
        this.valuesWithFastRandomAccess = new ArrayList<Value_>(size);
        this.valuesWithFastLookup = emptyCacheSet;
    }

    private ValueRangeCache(Collection<Value_> collection, Set<Value_> emptyCacheSet) {
        this.valuesWithFastRandomAccess = new ArrayList<Value_>(collection);
        this.valuesWithFastLookup = emptyCacheSet;
        this.valuesWithFastLookup.addAll(this.valuesWithFastRandomAccess);
    }

    public void add(@Nullable Value_ value) {
        if (this.valuesWithFastLookup.add(value)) {
            this.valuesWithFastRandomAccess.add(value);
        }
    }

    public Value_ get(int index) {
        if (index < 0 || index >= this.valuesWithFastRandomAccess.size()) {
            throw new IndexOutOfBoundsException("Index: %d, Size: %d".formatted(index, this.valuesWithFastRandomAccess.size()));
        }
        return this.valuesWithFastRandomAccess.get(index);
    }

    public boolean contains(@Nullable Value_ value) {
        return this.valuesWithFastLookup.contains(value);
    }

    public long getSize() {
        return this.valuesWithFastRandomAccess.size();
    }

    @Override
    public Iterator<Value_> iterator() {
        return this.valuesWithFastRandomAccess.iterator();
    }

    public Iterator<Value_> iterator(Random workingRandom) {
        return new CachedListRandomIterator<Value_>(this.valuesWithFastRandomAccess, workingRandom);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Builder {
        FOR_USER_VALUES{

            @Override
            public <Value_> ValueRangeCache<Value_> buildCache(int size) {
                return new ValueRangeCache(size, CollectionUtils.newIdentityHashSet(size));
            }

            @Override
            public <Value_> ValueRangeCache<Value_> buildCache(Collection<Value_> collection) {
                return new ValueRangeCache<Value_>(collection, CollectionUtils.newIdentityHashSet(collection.size()));
            }
        }
        ,
        FOR_TRUSTED_VALUES{

            @Override
            public <Value_> ValueRangeCache<Value_> buildCache(int size) {
                return new ValueRangeCache(size, CollectionUtils.newHashSet(size));
            }

            @Override
            public <Value_> ValueRangeCache<Value_> buildCache(Collection<Value_> collection) {
                return new ValueRangeCache<Value_>(collection, CollectionUtils.newHashSet(collection.size()));
            }
        };


        public abstract <Value_> ValueRangeCache<Value_> buildCache(int var1);

        public abstract <Value_> ValueRangeCache<Value_> buildCache(Collection<Value_> var1);
    }
}

