/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.decider;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.heuristic.move.LegacyMoveAdapter;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.ChangeMove;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructionHeuristicDecider<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String logIndentation;
    protected final PhaseTermination<Solution_> termination;
    protected final ConstructionHeuristicForager<Solution_> forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public ConstructionHeuristicDecider(String logIndentation, PhaseTermination<Solution_> termination, ConstructionHeuristicForager<Solution_> forager) {
        this.logIndentation = logIndentation;
        this.termination = termination;
        this.forager = forager;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public ConstructionHeuristicForager<Solution_> getForager() {
        return this.forager;
    }

    public void enableAssertions(EnvironmentMode environmentMode) {
        this.assertMoveScoreFromScratch = environmentMode.isFullyAsserted();
        this.assertExpectedUndoMoveScore = environmentMode.isIntrusivelyAsserted();
    }

    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.forager.solvingStarted(solverScope);
    }

    public void phaseStarted(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        this.forager.phaseStarted(phaseScope);
    }

    public void stepStarted(ConstructionHeuristicStepScope<Solution_> stepScope) {
        this.forager.stepStarted(stepScope);
    }

    public void stepEnded(ConstructionHeuristicStepScope<Solution_> stepScope) {
        this.forager.stepEnded(stepScope);
    }

    public void phaseEnded(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        this.forager.phaseEnded(phaseScope);
    }

    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.forager.solvingEnded(solverScope);
    }

    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
    }

    public void decideNextStep(ConstructionHeuristicStepScope<Solution_> stepScope, Iterator<Move<Solution_>> moveIterator) {
        int moveIndex = 0;
        boolean terminatedPrematurely = false;
        while (moveIterator.hasNext()) {
            MoveDirector moveDirector;
            Move<Solution_> move = moveIterator.next();
            boolean allowedNonDoableMove = ConstructionHeuristicDecider.isAllowedNonDoableMove(move);
            if (!allowedNonDoableMove && !LegacyMoveAdapter.isDoable(moveDirector = stepScope.getMoveDirector(), move)) continue;
            ConstructionHeuristicMoveScope<Solution_> moveScope = new ConstructionHeuristicMoveScope<Solution_>(stepScope, moveIndex, move);
            ++moveIndex;
            this.doMove(moveScope);
            if (this.forager.isQuitEarly()) break;
            stepScope.getPhaseScope().getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            terminatedPrematurely = true;
            break;
        }
        if (!terminatedPrematurely) {
            this.pickMove(stepScope);
        }
    }

    private static <Solution_> boolean isAllowedNonDoableMove(Move<Solution_> move) {
        if (move instanceof LegacyMoveAdapter) {
            LegacyMoveAdapter legacyMove = (LegacyMoveAdapter)move;
            ai.timefold.solver.core.impl.heuristic.move.Move adaptedMove = legacyMove.legacyMove();
            return adaptedMove instanceof NoChangeMove || adaptedMove instanceof ChangeMove;
        }
        return false;
    }

    protected void pickMove(ConstructionHeuristicStepScope<Solution_> stepScope) {
        ConstructionHeuristicMoveScope<Solution_> pickedMoveScope = this.forager.pickMove(stepScope);
        if (pickedMoveScope != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    protected void doMove(ConstructionHeuristicMoveScope<Solution_> moveScope) {
        InnerScoreDirector scoreDirector = moveScope.getScoreDirector();
        InnerScore score = scoreDirector.executeTemporaryMove(moveScope.getMove(), this.assertMoveScoreFromScratch);
        moveScope.setScore(score);
        this.forager.addMove(moveScope);
        if (this.assertExpectedUndoMoveScore) {
            scoreDirector.assertExpectedUndoMoveScore(moveScope.getMove(), ((ConstructionHeuristicPhaseScope)((ConstructionHeuristicStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore(), SolverLifecyclePoint.of(moveScope));
        }
        if (this.isLoggingEnabled()) {
            this.logger.trace("{}        Move index ({}), score ({}), move ({}).", new Object[]{this.logIndentation, moveScope.getMoveIndex(), moveScope.getScore().raw(), moveScope.getMove()});
        }
    }
}

