/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.tri;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;

public final class MapTriToBiNode<A, B, C, NewA, NewB>
extends AbstractMapNode<TriTuple<A, B, C>, BiTuple<NewA, NewB>> {
    private final TriFunction<A, B, C, NewA> mappingFunctionA;
    private final TriFunction<A, B, C, NewB> mappingFunctionB;

    public MapTriToBiNode(int mapStoreIndex, TriFunction<A, B, C, NewA> mappingFunctionA, TriFunction<A, B, C, NewB> mappingFunctionB, TupleLifecycle<BiTuple<NewA, NewB>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
    }

    @Override
    protected BiTuple<NewA, NewB> map(TriTuple<A, B, C> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        return new BiTuple<NewA, NewB>(this.mappingFunctionA.apply(factA, factB, factC), this.mappingFunctionB.apply(factA, factB, factC), this.outputStoreSize);
    }

    @Override
    protected void remap(TriTuple<A, B, C> inTuple, BiTuple<NewA, NewB> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        NewA newA = this.mappingFunctionA.apply(factA, factB, factC);
        NewB newB = this.mappingFunctionB.apply(factA, factB, factC);
        outTuple.factA = newA;
        outTuple.factB = newB;
    }
}

