/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.quad;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;

public final class MapQuadToBiNode<A, B, C, D, NewA, NewB>
extends AbstractMapNode<QuadTuple<A, B, C, D>, BiTuple<NewA, NewB>> {
    private final QuadFunction<A, B, C, D, NewA> mappingFunctionA;
    private final QuadFunction<A, B, C, D, NewB> mappingFunctionB;

    public MapQuadToBiNode(int mapStoreIndex, QuadFunction<A, B, C, D, NewA> mappingFunctionA, QuadFunction<A, B, C, D, NewB> mappingFunctionB, TupleLifecycle<BiTuple<NewA, NewB>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
    }

    @Override
    protected BiTuple<NewA, NewB> map(QuadTuple<A, B, C, D> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        Object factD = tuple.factD;
        return new BiTuple<NewA, NewB>(this.mappingFunctionA.apply(factA, factB, factC, factD), this.mappingFunctionB.apply(factA, factB, factC, factD), this.outputStoreSize);
    }

    @Override
    protected void remap(QuadTuple<A, B, C, D> inTuple, BiTuple<NewA, NewB> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        Object factD = inTuple.factD;
        NewA newA = this.mappingFunctionA.apply(factA, factB, factC, factD);
        NewB newB = this.mappingFunctionB.apply(factA, factB, factC, factD);
        outTuple.factA = newA;
        outTuple.factB = newB;
    }
}

