/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.PropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import java.util.ArrayDeque;
import java.util.Deque;

public final class StaticPropagationQueue<Tuple_ extends AbstractTuple>
implements PropagationQueue<Tuple_> {
    private final Deque<Tuple_> retractQueue;
    private final Deque<Tuple_> updateQueue;
    private final Deque<Tuple_> insertQueue;
    private final TupleLifecycle<Tuple_> nextNodesTupleLifecycle;

    public StaticPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, int size) {
        this.retractQueue = new ArrayDeque<Tuple_>(size / 20);
        this.updateQueue = new ArrayDeque<Tuple_>(size / 20 * 18);
        this.insertQueue = new ArrayDeque<Tuple_>(size / 20);
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
    }

    public StaticPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle) {
        this(nextNodesTupleLifecycle, 1000);
    }

    @Override
    public void insert(Tuple_ carrier) {
        if (((AbstractTuple)carrier).state == TupleState.CREATING) {
            throw new IllegalStateException("Impossible state: The tuple (%s) is already in the insert queue.".formatted(carrier));
        }
        ((AbstractTuple)carrier).state = TupleState.CREATING;
        this.insertQueue.add(carrier);
    }

    @Override
    public void update(Tuple_ carrier) {
        if (((AbstractTuple)carrier).state == TupleState.UPDATING) {
            return;
        }
        ((AbstractTuple)carrier).state = TupleState.UPDATING;
        this.updateQueue.add(carrier);
    }

    @Override
    public void retract(Tuple_ carrier, TupleState state) {
        TupleState carrierState = ((AbstractTuple)carrier).state;
        if (carrierState == state) {
            return;
        }
        if (state.isActive() || state == TupleState.DEAD) {
            throw new IllegalArgumentException("Impossible state: The state (%s) is not a valid retract state.".formatted(new Object[]{state}));
        }
        if (carrierState == TupleState.ABORTING || carrierState == TupleState.DYING) {
            throw new IllegalStateException("Impossible state: The tuple (%s) is already in the retract queue.".formatted(carrier));
        }
        ((AbstractTuple)carrier).state = state;
        this.retractQueue.add(carrier);
    }

    @Override
    public void propagateRetracts() {
        if (this.retractQueue.isEmpty()) {
            return;
        }
        for (AbstractTuple tuple : this.retractQueue) {
            switch (tuple.state) {
                case DYING: {
                    tuple.state = TupleState.DEAD;
                    this.nextNodesTupleLifecycle.retract(tuple);
                    break;
                }
                case ABORTING: {
                    tuple.state = TupleState.DEAD;
                }
            }
        }
        this.retractQueue.clear();
    }

    @Override
    public void propagateUpdates() {
        this.processAndClear(this.updateQueue);
    }

    private void processAndClear(Deque<Tuple_> dirtyQueue) {
        if (dirtyQueue.isEmpty()) {
            return;
        }
        for (AbstractTuple tuple : dirtyQueue) {
            if (tuple.state == TupleState.DEAD) continue;
            tuple.state = TupleState.OK;
            if (dirtyQueue == this.updateQueue) {
                this.nextNodesTupleLifecycle.update(tuple);
                continue;
            }
            this.nextNodesTupleLifecycle.insert(tuple);
        }
        dirtyQueue.clear();
    }

    @Override
    public void propagateInserts() {
        this.processAndClear(this.insertQueue);
        if (!this.retractQueue.isEmpty()) {
            throw new IllegalStateException("Impossible state: The retract queue (%s) is not empty.".formatted(this.retractQueue));
        }
        if (!this.updateQueue.isEmpty()) {
            throw new IllegalStateException("Impossible state: The update queue (%s) is not empty.".formatted(this.updateQueue));
        }
    }
}

