/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simple;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleScore
implements Score<SimpleScore> {
    public static final SimpleScore ZERO = new SimpleScore(0);
    public static final SimpleScore ONE = new SimpleScore(1);
    private static final SimpleScore MINUS_ONE = new SimpleScore(-1);
    private final int score;

    public static SimpleScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleScore.class, scoreString, "");
        int score = ScoreUtil.parseLevelAsInt(SimpleScore.class, scoreString, scoreTokens[0]);
        return SimpleScore.of(score);
    }

    @Deprecated(forRemoval=true, since="1.22.0")
    public static SimpleScore ofUninitialized(int initScore, int score) {
        return SimpleScore.of(score);
    }

    public static SimpleScore of(int score) {
        return switch (score) {
            case -1 -> MINUS_ONE;
            case 0 -> ZERO;
            case 1 -> ONE;
            default -> new SimpleScore(score);
        };
    }

    private SimpleScore() {
        this(Integer.MIN_VALUE);
    }

    private SimpleScore(int score) {
        this.score = score;
    }

    public int score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore add(SimpleScore addend) {
        return SimpleScore.of(this.score + addend.score());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return SimpleScore.of(this.score - subtrahend.score());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return SimpleScore.of((int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return SimpleScore.of((int)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleScore power(double exponent) {
        return SimpleScore.of((int)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleScore abs() {
        return SimpleScore.of(Math.abs(this.score));
    }

    @Override
    public SimpleScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return true;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.score == other.score();
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.score);
    }

    @Override
    public int compareTo(SimpleScore other) {
        return Integer.compare(this.score, other.score());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "");
    }

    public String toString() {
        return Integer.toString(this.score);
    }
}

