/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.function;

import java.util.Objects;
import org.jspecify.annotations.NonNull;

@FunctionalInterface
public interface QuadPredicate<A, B, C, D> {
    public boolean test(A var1, B var2, C var3, D var4);

    default public @NonNull QuadPredicate<A, B, C, D> and(@NonNull QuadPredicate<? super A, ? super B, ? super C, ? super D> other) {
        Objects.requireNonNull(other);
        return (a, b, c, d) -> this.test(a, b, c, d) && other.test(a, b, c, d);
    }

    default public QuadPredicate<A, B, C, D> negate() {
        return (a, b, c, d) -> !this.test(a, b, c, d);
    }

    default public @NonNull QuadPredicate<A, B, C, D> or(@NonNull QuadPredicate<? super A, ? super B, ? super C, ? super D> other) {
        Objects.requireNonNull(other);
        return (a, b, c, d) -> this.test(a, b, c, d) || other.test(a, b, c, d);
    }
}

