/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.api.score.stream.common.ConnectedRange;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ConnectedSubrangeIterator;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ContainedRangeIterator;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.Range;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeSplitPoint;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jspecify.annotations.NonNull;

final class ConnectedRangeImpl<Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements ConnectedRange<Range_, Point_, Difference_> {
    private final NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet;
    private final BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction;
    private RangeSplitPoint<Range_, Point_> startSplitPoint;
    private RangeSplitPoint<Range_, Point_> endSplitPoint;
    private int count;
    private int minimumOverlap;
    private int maximumOverlap;
    private boolean hasOverlap;

    ConnectedRangeImpl(NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction, RangeSplitPoint<Range_, Point_> start, RangeSplitPoint<Range_, Point_> end, int count, int minimumOverlap, int maximumOverlap, boolean hasOverlap) {
        this.splitPointSet = splitPointSet;
        this.startSplitPoint = start;
        this.endSplitPoint = end;
        this.differenceFunction = differenceFunction;
        this.count = count;
        this.minimumOverlap = minimumOverlap;
        this.maximumOverlap = maximumOverlap;
        this.hasOverlap = hasOverlap;
    }

    static <Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> ConnectedRangeImpl<Range_, Point_, Difference_> getConnectedRangeStartingAt(NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction, RangeSplitPoint<Range_, Point_> start) {
        return new ConnectedSubrangeIterator<Range_, Point_, Difference_>(splitPointSet, start, (RangeSplitPoint)splitPointSet.last(), differenceFunction).next();
    }

    RangeSplitPoint<Range_, Point_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    RangeSplitPoint<Range_, Point_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    void addRange(Range<Range_, Point_> range) {
        if (range.getEndSplitPoint().compareTo(this.getStartSplitPoint()) > 0 && range.getStartSplitPoint().compareTo(this.getEndSplitPoint()) < 0) {
            this.hasOverlap = true;
        }
        if (range.getStartSplitPoint().compareTo(this.startSplitPoint) < 0) {
            this.startSplitPoint = this.splitPointSet.floor(range.getStartSplitPoint());
        }
        if (range.getEndSplitPoint().compareTo(this.endSplitPoint) > 0) {
            this.endSplitPoint = this.splitPointSet.ceiling(range.getEndSplitPoint());
        }
        this.minimumOverlap = -1;
        this.maximumOverlap = -1;
        ++this.count;
    }

    Iterable<ConnectedRangeImpl<Range_, Point_, Difference_>> getNewConnectedRanges(NavigableSet<RangeSplitPoint<Range_, Point_>> newSplitPointSet) {
        return () -> new ConnectedSubrangeIterator<Range_, Point_, Difference_>(newSplitPointSet, this.startSplitPoint, this.endSplitPoint, this.differenceFunction);
    }

    void mergeConnectedRange(ConnectedRangeImpl<Range_, Point_, Difference_> laterConnectedRange) {
        if (this.endSplitPoint.compareTo(laterConnectedRange.startSplitPoint) > 0) {
            this.hasOverlap = true;
        }
        if (this.endSplitPoint.compareTo(laterConnectedRange.endSplitPoint) < 0) {
            this.endSplitPoint = laterConnectedRange.endSplitPoint;
        }
        this.count += laterConnectedRange.count;
        this.minimumOverlap = -1;
        this.maximumOverlap = -1;
        this.hasOverlap |= laterConnectedRange.hasOverlap;
    }

    @Override
    public Iterator<Range_> iterator() {
        return new ContainedRangeIterator<Range_, Point_>(this.splitPointSet.subSet(this.startSplitPoint, true, this.endSplitPoint, true));
    }

    @Override
    public int getContainedRangeCount() {
        return this.count;
    }

    @Override
    public boolean hasOverlap() {
        return this.hasOverlap;
    }

    private void recalculateMinimumAndMaximumOverlap() {
        RangeSplitPoint<Range_, Point_> current = this.startSplitPoint;
        int activeRangeCount = 0;
        this.minimumOverlap = Integer.MAX_VALUE;
        this.maximumOverlap = Integer.MIN_VALUE;
        do {
            if ((activeRangeCount += current.rangesStartingAtSplitPointSet.size() - current.rangesEndingAtSplitPointSet.size()) > 0) {
                this.minimumOverlap = Math.min(this.minimumOverlap, activeRangeCount);
                this.maximumOverlap = Math.max(this.maximumOverlap, activeRangeCount);
            }
            current = this.splitPointSet.higher(current);
        } while (activeRangeCount > 0 && current != null);
    }

    @Override
    public int getMinimumOverlap() {
        if (this.minimumOverlap == -1) {
            this.recalculateMinimumAndMaximumOverlap();
        }
        return this.minimumOverlap;
    }

    @Override
    public int getMaximumOverlap() {
        if (this.maximumOverlap == -1) {
            this.recalculateMinimumAndMaximumOverlap();
        }
        return this.maximumOverlap;
    }

    @Override
    public @NonNull Point_ getStart() {
        return this.startSplitPoint.splitPoint;
    }

    @Override
    public @NonNull Point_ getEnd() {
        return this.endSplitPoint.splitPoint;
    }

    @Override
    public @NonNull Difference_ getLength() {
        return (Difference_)((Comparable)this.differenceFunction.apply(this.startSplitPoint.splitPoint, this.endSplitPoint.splitPoint));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectedRangeImpl)) {
            return false;
        }
        ConnectedRangeImpl that = (ConnectedRangeImpl)o;
        return this.count == that.count && this.getMinimumOverlap() == that.getMinimumOverlap() && this.getMaximumOverlap() == that.getMaximumOverlap() && this.hasOverlap == that.hasOverlap && Objects.equals(this.splitPointSet, that.splitPointSet) && Objects.equals(this.startSplitPoint, that.startSplitPoint) && Objects.equals(this.endSplitPoint, that.endSplitPoint);
    }

    public int hashCode() {
        return Objects.hash(this.splitPointSet, this.startSplitPoint, this.endSplitPoint, this.count, this.getMinimumOverlap(), this.getMaximumOverlap(), this.hasOverlap);
    }

    public String toString() {
        return "ConnectedRange {start=" + String.valueOf(this.startSplitPoint) + ", end=" + String.valueOf(this.endSplitPoint) + ", count=" + this.count + ", minimumOverlap=" + this.getMinimumOverlap() + ", maximumOverlap=" + this.getMaximumOverlap() + ", hasOverlap=" + this.hasOverlap + "}";
    }
}

