/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.move.streams.DefaultBiFromBiMoveStream;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamSession;
import ai.timefold.solver.core.impl.move.streams.DefaultUniMoveStream;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetSession;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetSessionFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.bi.AbstractBiDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.uni.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.DataJoiners;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiMoveStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniMoveStream;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultMoveStreamFactory<Solution_>
implements MoveStreamFactory<Solution_> {
    private final DataStreamFactory<Solution_> dataStreamFactory;
    private final DatasetSessionFactory<Solution_> datasetSessionFactory;

    public DefaultMoveStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.dataStreamFactory = new DataStreamFactory<Solution_>(solutionDescriptor, environmentMode);
        this.datasetSessionFactory = new DatasetSessionFactory<Solution_>(this.dataStreamFactory);
    }

    public DefaultMoveStreamSession<Solution_> createSession(SessionContext<Solution_> context) {
        DatasetSession<Solution_> session = this.datasetSessionFactory.buildSession(context);
        return new DefaultMoveStreamSession<Solution_>(session, context.solutionView());
    }

    @Override
    public <A> UniDataStream<Solution_, A> enumerate(Class<A> sourceClass, boolean includeNull) {
        EntityDescriptor<Solution_> entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(sourceClass);
        if (entityDescriptor == null) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (entityDescriptor.isGenuine()) {
            return this.dataStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.getSolutionDescriptor().getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.supportsPinning()) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        return this.dataStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
    }

    @Override
    public <A> UniDataStream<Solution_, A> enumerateIncludingPinned(Class<A> sourceClass, boolean includeNull) {
        return this.dataStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
    }

    @Override
    public <Entity_, Value_> BiDataStream<Solution_, Entity_, Value_> enumerateEntityValuePairs(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, UniDataStream<Solution_, Entity_> entityDataStream) {
        boolean bl;
        if (variableMetaModel instanceof PlanningVariableMetaModel) {
            PlanningVariableMetaModel planningVariableMetaModel = (PlanningVariableMetaModel)variableMetaModel;
            bl = planningVariableMetaModel.allowsUnassigned();
        } else {
            PlanningListVariableMetaModel planningListVariableMetaModel;
            bl = variableMetaModel instanceof PlanningListVariableMetaModel && (planningListVariableMetaModel = (PlanningListVariableMetaModel)variableMetaModel).allowsUnassignedValues();
        }
        boolean includeNull = bl;
        UniDataStream stream = this.dataStreamFactory.forEachExcludingPinned(variableMetaModel.type(), includeNull);
        return entityDataStream.join(stream, DataJoiners.filtering((solutionView, entity, value) -> solutionView.isValueInRange(variableMetaModel, entity, value)));
    }

    @Override
    public <A> UniMoveStream<Solution_, A> pick(UniDataStream<Solution_, A> dataStream) {
        return new DefaultUniMoveStream(this, ((AbstractUniDataStream)dataStream).createDataset());
    }

    @Override
    public <A, B> BiMoveStream<Solution_, A, B> pick(BiDataStream<Solution_, A, B> dataStream) {
        return new DefaultBiFromBiMoveStream(((AbstractBiDataStream)dataStream).createDataset());
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.dataStreamFactory.getSolutionDescriptor();
    }
}

