/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset.uni;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.IndexedIfExistsUniNode;
import ai.timefold.solver.core.impl.bavet.uni.UnindexedIfExistsUniNode;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.common.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.move.streams.dataset.common.IfExistsDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.bridge.ForeBridgeUniDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.DefaultBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.dataset.uni.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class IfExistsUniDataStream<Solution_, A, B>
extends AbstractUniDataStream<Solution_, A>
implements IfExistsDataStream<Solution_> {
    private final AbstractUniDataStream<Solution_, A> parentA;
    private final ForeBridgeUniDataStream<Solution_, B> parentBridgeB;
    private final boolean shouldExist;
    private final DefaultBiDataJoiner<A, B> joiner;
    private final @Nullable BiDataFilter<Solution_, A, B> filtering;

    public IfExistsUniDataStream(DataStreamFactory<Solution_> dataStreamFactory, AbstractUniDataStream<Solution_, A> parentA, ForeBridgeUniDataStream<Solution_, B> parentBridgeB, boolean shouldExist, DefaultBiDataJoiner<A, B> joiner, @Nullable BiDataFilter<Solution_, A, B> filtering) {
        super(dataStreamFactory);
        this.parentA = parentA;
        this.parentBridgeB = parentBridgeB;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> dataStreamSet) {
        this.parentA.collectActiveDataStreams(dataStreamSet);
        this.parentBridgeB.collectActiveDataStreams(dataStreamSet);
        dataStreamSet.add(this);
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        TupleLifecycle<UniTuple<A>> downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory<B> indexerFactory = new IndexerFactory<B>(this.joiner.toBiJoiner());
        AbstractIfExistsNode<UniTuple<A>, B> node = this.getNode(indexerFactory, buildHelper, downstream);
        buildHelper.addNode(node, this, this, this.parentBridgeB);
    }

    private AbstractIfExistsNode<UniTuple<A>, B> getNode(IndexerFactory<B> indexerFactory, DataNodeBuildHelper<Solution_> buildHelper, TupleLifecycle<UniTuple<A>> downstream) {
        boolean isFiltering;
        SessionContext<Solution_> sessionContext = buildHelper.getSessionContext();
        boolean bl = isFiltering = this.filtering != null;
        if (indexerFactory.hasJoiners()) {
            if (isFiltering) {
                return new IndexedIfExistsUniNode<A, B>(this.shouldExist, indexerFactory, buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), downstream, this.filtering.toBiPredicate(sessionContext.solutionView()));
            }
            return new IndexedIfExistsUniNode<A, B>(this.shouldExist, indexerFactory, buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), downstream);
        }
        if (isFiltering) {
            return new UnindexedIfExistsUniNode<A, B>(this.shouldExist, buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), downstream, this.filtering.toBiPredicate(sessionContext.solutionView()));
        }
        return new UnindexedIfExistsUniNode(this.shouldExist, buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource()), downstream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof IfExistsUniDataStream)) return false;
        IfExistsUniDataStream that = (IfExistsUniDataStream)o;
        if (this.shouldExist != that.shouldExist) return false;
        if (!Objects.equals(this.parentA, that.parentA)) return false;
        if (!Objects.equals(this.parentBridgeB, that.parentBridgeB)) return false;
        if (!Objects.equals(this.joiner, that.joiner)) return false;
        if (!Objects.equals(this.filtering, that.filtering)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parentA, this.parentBridgeB, this.shouldExist, this.joiner, this.filtering);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }

    @Override
    public AbstractDataStream<Solution_> getTupleSource() {
        return this.parentA.getTupleSource();
    }

    @Override
    public AbstractDataStream<Solution_> getLeftParent() {
        return this.parentA;
    }

    @Override
    public AbstractDataStream<Solution_> getRightParent() {
        return this.parentBridgeB;
    }
}

