/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset.uni;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.move.streams.dataset.uni.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.UniDataFilter;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class FilterUniDataStream<Solution_, A>
extends AbstractUniDataStream<Solution_, A> {
    private final UniDataFilter<Solution_, A> filter;

    public FilterUniDataStream(DataStreamFactory<Solution_> dataStreamFactory, AbstractUniDataStream<Solution_, A> parent, UniDataFilter<Solution_, A> filter) {
        super(dataStreamFactory, parent);
        this.filter = Objects.requireNonNull(filter, "The filter cannot be null.");
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        Predicate predicate = this.filter.toPredicate(buildHelper.getSessionContext().solutionView());
        buildHelper.putInsertUpdateRetract(this, this.childStreamList, tupleLifecycle -> TupleLifecycle.conditionally(tupleLifecycle, predicate));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FilterUniDataStream) {
            FilterUniDataStream other = (FilterUniDataStream)o;
            return this.parent == other.parent && this.filter == other.filter;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }
}

