/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.exhaustivesearch.ExhaustiveSearchPhase;
import ai.timefold.solver.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import ai.timefold.solver.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.CompositeMove;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public class DefaultExhaustiveSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements ExhaustiveSearchPhase<Solution_> {
    protected final Comparator<ExhaustiveSearchNode> nodeComparator;
    protected final EntitySelector<Solution_> entitySelector;
    protected final ExhaustiveSearchDecider<Solution_> decider;
    protected final boolean assertWorkingSolutionScoreFromScratch;
    protected final boolean assertExpectedWorkingSolutionScore;

    private DefaultExhaustiveSearchPhase(Builder<Solution_> builder) {
        super(builder);
        this.nodeComparator = builder.nodeComparator;
        this.entitySelector = builder.entitySelector;
        this.decider = builder.decider;
        this.assertWorkingSolutionScoreFromScratch = builder.assertWorkingSolutionScoreFromScratch;
        this.assertExpectedWorkingSolutionScore = builder.assertExpectedWorkingSolutionScore;
    }

    @Override
    public String getPhaseTypeString() {
        return "Exhaustive Search";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        TreeSet<ExhaustiveSearchNode> expandableNodeQueue = new TreeSet<ExhaustiveSearchNode>(this.nodeComparator);
        ExhaustiveSearchPhaseScope<Solution_> phaseScope = new ExhaustiveSearchPhaseScope<Solution_>(solverScope, this.phaseIndex);
        phaseScope.setExpandableNodeQueue(expandableNodeQueue);
        this.phaseStarted(phaseScope);
        while (!expandableNodeQueue.isEmpty() && !this.phaseTermination.isPhaseTerminated(phaseScope)) {
            ExhaustiveSearchStepScope<Solution_> stepScope = new ExhaustiveSearchStepScope<Solution_>(phaseScope);
            ExhaustiveSearchNode node = expandableNodeQueue.last();
            expandableNodeQueue.remove(node);
            stepScope.setExpandingNode(node);
            this.stepStarted(stepScope);
            this.restoreWorkingSolution(stepScope);
            this.decider.expandNode(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitySelector.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        this.fillLayerList(phaseScope);
        this.initStartNode(phaseScope);
    }

    private void fillLayerList(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        ExhaustiveSearchStepScope<Solution_> stepScope = new ExhaustiveSearchStepScope<Solution_>(phaseScope);
        this.entitySelector.stepStarted(stepScope);
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The entitySelector (" + String.valueOf(this.entitySelector) + ") has an entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList<ExhaustiveSearchLayer> layerList = new ArrayList<ExhaustiveSearchLayer>((int)entitySize);
        int depth = 0;
        for (Object t : this.entitySelector) {
            ExhaustiveSearchLayer layer = new ExhaustiveSearchLayer(depth, t);
            int reinitializeVariableCount = this.entitySelector.getEntityDescriptor().countReinitializableVariables(t);
            if (reinitializeVariableCount == 0) continue;
            ++depth;
            layerList.add(layer);
        }
        ExhaustiveSearchLayer lastLayer = new ExhaustiveSearchLayer(depth, null);
        layerList.add(lastLayer);
        this.entitySelector.stepEnded(stepScope);
        phaseScope.setLayerList(layerList);
    }

    private <Score_ extends Score<Score_>> void initStartNode(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        ExhaustiveSearchLayer startLayer = phaseScope.getLayerList().get(0);
        ExhaustiveSearchNode startNode = new ExhaustiveSearchNode(startLayer, null);
        if (this.decider.isScoreBounderEnabled()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            InnerScore score = scoreDirector.calculateScore();
            startNode.setScore(score);
            ScoreBounder scoreBounder = this.decider.getScoreBounder();
            phaseScope.setBestPessimisticBound(startLayer.isLastLayer() ? score : scoreBounder.calculatePessimisticBound(scoreDirector, score));
            startNode.setOptimisticBound(startLayer.isLastLayer() ? score : scoreBounder.calculateOptimisticBound(scoreDirector, score));
        }
        if (!startLayer.isLastLayer()) {
            phaseScope.addExpandableNode(startNode);
        }
        ((ExhaustiveSearchStepScope)phaseScope.getLastCompletedStepScope()).setExpandingNode(startNode);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    protected <Score_ extends Score<Score_>> void restoreWorkingSolution(ExhaustiveSearchStepScope<Solution_> stepScope) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchNode oldNode = ((ExhaustiveSearchStepScope)((ExhaustiveSearchPhaseScope)phaseScope).getLastCompletedStepScope()).getExpandingNode();
        ExhaustiveSearchNode newNode = stepScope.getExpandingNode();
        ArrayList<Move> oldMoveList = new ArrayList<Move>(oldNode.getDepth());
        ArrayList<Move> newMoveList = new ArrayList<Move>(newNode.getDepth());
        while (oldNode != newNode) {
            int newDepth;
            int oldDepth = oldNode.getDepth();
            if (oldDepth < (newDepth = newNode.getDepth())) {
                newMoveList.add(newNode.getMove());
                newNode = newNode.getParent();
                continue;
            }
            oldMoveList.add(oldNode.getUndoMove());
            oldNode = oldNode.getParent();
        }
        ArrayList<Move> restoreMoveList = new ArrayList<Move>(oldMoveList.size() + newMoveList.size());
        restoreMoveList.addAll(oldMoveList);
        Collections.reverse(newMoveList);
        restoreMoveList.addAll(newMoveList);
        if (restoreMoveList.isEmpty()) {
            return;
        }
        Move compositeMove = CompositeMove.buildMove(restoreMoveList);
        phaseScope.getScoreDirector().executeMove(compositeMove);
        InnerScore startingStepScore = stepScope.getStartingStepScore();
        phaseScope.getSolutionDescriptor().setScore(phaseScope.getWorkingSolution(), startingStepScore == null ? null : (Score)startingStepScore.raw());
        if (this.assertWorkingSolutionScoreFromScratch && stepScope.getStartingStepScore() != null) {
            phaseScope.assertPredictedScoreFromScratch(stepScope.getStartingStepScore(), restoreMoveList);
        }
        if (this.assertExpectedWorkingSolutionScore && stepScope.getStartingStepScore() != null) {
            phaseScope.assertExpectedWorkingScore(stepScope.getStartingStepScore(), restoreMoveList);
        }
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
            this.logger.debug("{}    ES step ({}), time spent ({}), treeId ({}), {} best score ({}), selected move count ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getTreeId(), stepScope.getBestScoreImproved() ? "new" : "   ", phaseScope.getBestScore().raw(), stepScope.getSelectedMoveCount()});
        }
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.entitySelector.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Exhaustive Search phase ({}) ended: time spent ({}), best score ({}), move evaluation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore().raw(), phaseScope.getPhaseMoveEvaluationSpeed(), phaseScope.getNextStepIndex()});
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.entitySelector.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }

    public static class Builder<Solution_>
    extends AbstractPhase.AbstractPhaseBuilder<Solution_> {
        private final Comparator<ExhaustiveSearchNode> nodeComparator;
        private final EntitySelector<Solution_> entitySelector;
        private final ExhaustiveSearchDecider<Solution_> decider;
        private boolean assertWorkingSolutionScoreFromScratch = false;
        private boolean assertExpectedWorkingSolutionScore = false;

        public Builder(int phaseIndex, String logIndentation, PhaseTermination<Solution_> phaseTermination, Comparator<ExhaustiveSearchNode> nodeComparator, EntitySelector<Solution_> entitySelector, ExhaustiveSearchDecider<Solution_> decider) {
            super(phaseIndex, logIndentation, phaseTermination);
            this.nodeComparator = nodeComparator;
            this.entitySelector = entitySelector;
            this.decider = decider;
        }

        @Override
        public Builder<Solution_> enableAssertions(EnvironmentMode environmentMode) {
            super.enableAssertions(environmentMode);
            this.assertWorkingSolutionScoreFromScratch = environmentMode.isFullyAsserted();
            this.assertExpectedWorkingSolutionScore = environmentMode.isIntrusivelyAsserted();
            return this;
        }

        @Override
        public DefaultExhaustiveSearchPhase<Solution_> build() {
            return new DefaultExhaustiveSearchPhase(this);
        }
    }
}

