/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.KeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.ManyKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.NoneIndexer;
import ai.timefold.solver.core.impl.bavet.common.index.SingleKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.joiner.JoinerType;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class ComparisonIndexer<T, Key_ extends Comparable<Key_>>
implements Indexer<T> {
    private final KeyRetriever<Key_> keyRetriever;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Comparator<Key_> keyComparator;
    private final boolean hasOrEquals;
    private final NavigableMap<Key_, Indexer<T>> comparisonMap;

    public ComparisonIndexer(JoinerType comparisonJoinerType) {
        this(comparisonJoinerType, new SingleKeyRetriever(), NoneIndexer::new);
    }

    public ComparisonIndexer(JoinerType comparisonJoinerType, int keyIndex, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this(comparisonJoinerType, new ManyKeyRetriever(keyIndex), downstreamIndexerSupplier);
    }

    private ComparisonIndexer(JoinerType comparisonJoinerType, KeyRetriever<Key_> keyRetriever, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.keyRetriever = Objects.requireNonNull(keyRetriever);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
        this.keyComparator = comparisonJoinerType == JoinerType.GREATER_THAN || comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL ? Comparator.naturalOrder().reversed() : Comparator.naturalOrder();
        this.hasOrEquals = comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL || comparisonJoinerType == JoinerType.LESS_THAN_OR_EQUAL;
        this.comparisonMap = new TreeMap<Key_, Indexer<T>>(this.keyComparator);
    }

    @Override
    public ElementAwareListEntry<T> put(Object indexKeys, T tuple) {
        Comparable indexKey = (Comparable)this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = (Indexer<T>)this.comparisonMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.comparisonMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(indexKeys, tuple);
    }

    @Override
    public void remove(Object indexKeys, ElementAwareListEntry<T> entry) {
        Comparable indexKey = (Comparable)this.keyRetriever.apply(indexKeys);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(indexKeys, indexKey, entry);
        downstreamIndexer.remove(indexKeys, entry);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(Object indexKeys, Key_ indexerKey, ElementAwareListEntry<T> entry) {
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (%s) with indexKeys (%s) doesn't exist in the indexer %s.".formatted(entry.getElement(), indexKeys, this));
        }
        return downstreamIndexer;
    }

    @Override
    public int size(Object indexKeys) {
        Map.Entry entry;
        int comparison;
        int mapSize = this.comparisonMap.size();
        if (mapSize == 0) {
            return 0;
        }
        Comparable indexKey = (Comparable)this.keyRetriever.apply(indexKeys);
        if (mapSize == 1) {
            Map.Entry<Key_, Indexer<T>> entry2 = this.comparisonMap.firstEntry();
            int comparison2 = this.keyComparator.compare((Comparable)entry2.getKey(), indexKey);
            if (!(comparison2 < 0 || comparison2 <= 0 && this.hasOrEquals)) {
                return 0;
            }
            return entry2.getValue().size(indexKeys);
        }
        int size = 0;
        Iterator iterator = this.comparisonMap.entrySet().iterator();
        while (iterator.hasNext() && ((comparison = this.keyComparator.compare((Comparable)(entry = iterator.next()).getKey(), indexKey)) < 0 || comparison <= 0 && this.hasOrEquals)) {
            size += ((Indexer)entry.getValue()).size(indexKeys);
        }
        return size;
    }

    @Override
    public void forEach(Object indexKeys, Consumer<T> tupleConsumer) {
        int size = this.comparisonMap.size();
        if (size == 0) {
            return;
        }
        Comparable indexKey = (Comparable)this.keyRetriever.apply(indexKeys);
        if (size == 1) {
            Map.Entry<Key_, Indexer<T>> entry = this.comparisonMap.firstEntry();
            this.visitEntry(indexKeys, tupleConsumer, indexKey, entry);
        } else {
            for (Map.Entry entry : this.comparisonMap.entrySet()) {
                boolean boundaryReached = this.visitEntry(indexKeys, tupleConsumer, indexKey, entry);
                if (!boundaryReached) continue;
                return;
            }
        }
    }

    private boolean visitEntry(Object indexKeys, Consumer<T> tupleConsumer, Key_ indexKey, Map.Entry<Key_, Indexer<T>> entry) {
        int comparison = this.keyComparator.compare((Comparable)entry.getKey(), indexKey);
        if (!(comparison < 0 || comparison <= 0 && this.hasOrEquals)) {
            return true;
        }
        entry.getValue().forEach(indexKeys, tupleConsumer);
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }

    public String toString() {
        return "size = " + this.comparisonMap.size();
    }
}

