/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.common;

import jakarta.xml.bind.annotation.XmlEnum;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlEnum
public enum SelectionOrder {
    INHERIT,
    ORIGINAL,
    SORTED,
    RANDOM,
    SHUFFLED,
    PROBABILISTIC;


    public static @NonNull SelectionOrder resolve(@Nullable SelectionOrder selectionOrder, @NonNull SelectionOrder inheritedSelectionOrder) {
        if (selectionOrder == null || selectionOrder == INHERIT) {
            return Objects.requireNonNull(inheritedSelectionOrder, "The inheritedSelectionOrder cannot be null.");
        }
        return selectionOrder;
    }

    public static @NonNull SelectionOrder fromRandomSelectionBoolean(boolean randomSelection) {
        return randomSelection ? RANDOM : ORIGINAL;
    }

    public boolean toRandomSelectionBoolean() {
        if (this == RANDOM) {
            return true;
        }
        if (this == ORIGINAL) {
            return false;
        }
        throw new IllegalStateException("The selectionOrder (" + String.valueOf((Object)this) + ") cannot be casted to a randomSelectionBoolean.");
    }
}

