/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.LoadBalanceImpl;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

final class LoadBalanceTriCollector<A, B, C, Balanced_>
implements TriConstraintCollector<A, B, C, LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> {
    private final TriFunction<A, B, C, Balanced_> balancedItemFunction;
    private final ToLongTriFunction<A, B, C> loadFunction;
    private final ToLongTriFunction<A, B, C> initialLoadFunction;

    public LoadBalanceTriCollector(TriFunction<A, B, C, Balanced_> balancedItemFunction, ToLongTriFunction<A, B, C> loadFunction, ToLongTriFunction<A, B, C> initialLoadFunction) {
        this.balancedItemFunction = balancedItemFunction;
        this.loadFunction = loadFunction;
        this.initialLoadFunction = initialLoadFunction;
    }

    @Override
    public @NonNull Supplier<LoadBalanceImpl<Balanced_>> supplier() {
        return LoadBalanceImpl::new;
    }

    @Override
    public @NonNull QuadFunction<LoadBalanceImpl<Balanced_>, A, B, C, Runnable> accumulator() {
        return (balanceStatistics, a, b, c) -> {
            Balanced_ balanced = this.balancedItemFunction.apply(a, b, c);
            long initialLoad = this.initialLoadFunction.applyAsLong(a, b, c);
            long load = this.loadFunction.applyAsLong(a, b, c);
            return balanceStatistics.registerBalanced(balanced, load, initialLoad);
        };
    }

    @Override
    public @NonNull Function<LoadBalanceImpl<Balanced_>, LoadBalance<Balanced_>> finisher() {
        return balanceStatistics -> balanceStatistics;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof LoadBalanceTriCollector)) return false;
        LoadBalanceTriCollector that = (LoadBalanceTriCollector)o;
        if (!Objects.equals(this.balancedItemFunction, that.balancedItemFunction)) return false;
        if (!Objects.equals(this.loadFunction, that.loadFunction)) return false;
        if (!Objects.equals(this.initialLoadFunction, that.initialLoadFunction)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.balancedItemFunction, this.loadFunction, this.initialLoadFunction);
    }
}

