/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.provider;

import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import ai.timefold.solver.core.impl.move.streams.maybeapi.DataJoiners;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.ListAssignMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.ListChangeMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.ListUnassignMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProducer;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProvider;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.domain.metamodel.UnassignedElement;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ListChangeMoveProvider<Solution_, Entity_, Value_>
implements MoveProvider<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final BiDataFilter<Solution_, Entity_, Value_> isValueInListFilter;

    public ListChangeMoveProvider(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.isValueInListFilter = (solution, entity, value) -> {
            if (entity == null || value == null) {
                return true;
            }
            return solution.isValueInRange(variableMetaModel, entity, value);
        };
    }

    @Override
    public MoveProducer<Solution_> apply(MoveStreamFactory<Solution_> moveStreamFactory) {
        UniDataStream unpinnedEntities = moveStreamFactory.enumerate(this.variableMetaModel.entity().type(), this.variableMetaModel.allowsUnassignedValues());
        UniDataStream<Solution_, Object> unpinnedValues = moveStreamFactory.enumerate(this.variableMetaModel.type(), true).filter((solutionView, value) -> value == null || solutionView.getPositionOf(this.variableMetaModel, value) instanceof PositionInList);
        UniDataStream<Solution_, ElementPosition> entityValuePairs = unpinnedEntities.join(unpinnedValues, DataJoiners.filtering(this.isValueInListFilter)).map((solutionView, entity, value) -> {
            if (entity == null) {
                return ElementPosition.unassigned();
            }
            int valueCount = solutionView.countValues(this.variableMetaModel, entity);
            if (value == null || valueCount == 0) {
                return ElementPosition.of(entity, valueCount);
            }
            return solutionView.getPositionOf(this.variableMetaModel, value);
        }).distinct();
        BiDataStream dataStream = moveStreamFactory.enumerate(this.variableMetaModel.type(), false).join(entityValuePairs, DataJoiners.filtering(this::isValidChange));
        return moveStreamFactory.pick(dataStream).asMove((solutionView, value, targetPosition) -> {
            ElementPosition currentPosition = solutionView.getPositionOf(this.variableMetaModel, Objects.requireNonNull(value));
            if (targetPosition instanceof UnassignedElement) {
                PositionInList currentElementPosition = currentPosition.ensureAssigned();
                return new ListUnassignMove<Solution_, Entity_, Object>(this.variableMetaModel, value, currentElementPosition.entity(), currentElementPosition.index());
            }
            PositionInList targetElementPosition = Objects.requireNonNull(targetPosition).ensureAssigned();
            if (currentPosition instanceof UnassignedElement) {
                return new ListAssignMove<Solution_, Entity_, Object>(this.variableMetaModel, value, targetElementPosition.entity(), targetElementPosition.index());
            }
            PositionInList currentElementPosition = currentPosition.ensureAssigned();
            return new ListChangeMove<Solution_, Entity_, Value_>(this.variableMetaModel, currentElementPosition.entity(), currentElementPosition.index(), targetElementPosition.entity(), targetElementPosition.index());
        });
    }

    private boolean isValidChange(SolutionView<Solution_> solutionView, Value_ value, ElementPosition targetPosition) {
        ElementPosition currentPosition = solutionView.getPositionOf(this.variableMetaModel, value);
        if (currentPosition.equals(targetPosition)) {
            return false;
        }
        if (currentPosition instanceof UnassignedElement) {
            PositionInList targetPositionInList = targetPosition.ensureAssigned();
            return solutionView.isValueInRange(this.variableMetaModel, targetPositionInList.entity(), value);
        }
        if (!(targetPosition instanceof PositionInList)) {
            return true;
        }
        PositionInList targetPositionInList = (PositionInList)targetPosition;
        PositionInList currentPositionInList = currentPosition.ensureAssigned();
        if (currentPositionInList.entity() == targetPositionInList.entity()) {
            int valueCount = solutionView.countValues(this.variableMetaModel, currentPositionInList.entity());
            if (valueCount == 1) {
                return false;
            }
            if (targetPositionInList.index() == valueCount) {
                return false;
            }
            return currentPositionInList.index() != targetPositionInList.index();
        }
        return solutionView.isValueInRange(this.variableMetaModel, targetPositionInList.entity(), value);
    }
}

