/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListSwapMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ListSwapMoveSelectorConfig> {
    public ListSwapMoveSelectorFactory(ListSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        GenuineVariableDescriptor variableDescriptor;
        ValueSelectorConfig valueSelectorConfig = Objects.requireNonNullElseGet(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig(), ValueSelectorConfig::new);
        ValueSelectorConfig secondaryValueSelectorConfig = Objects.requireNonNullElseGet(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig(), valueSelectorConfig::copyConfig);
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptorWithListVariable(configPolicy.getSolutionDescriptor());
        boolean enableEntityValueRangeFilter = !entityDescriptor.getGenuineListVariableDescriptor().canExtractValueRangeFromSolution();
        String mimicSelectorId = null;
        if (enableEntityValueRangeFilter) {
            if (valueSelectorConfig.getId() == null && valueSelectorConfig.getMimicSelectorRef() == null) {
                String variableName = Objects.requireNonNull(valueSelectorConfig.getVariableName());
                mimicSelectorId = ConfigUtils.addRandomSuffix(variableName, configPolicy.getRandom());
                valueSelectorConfig.setId(mimicSelectorId);
            } else {
                mimicSelectorId = valueSelectorConfig.getId() != null ? valueSelectorConfig.getId() : valueSelectorConfig.getMimicSelectorRef();
            }
        }
        IterableValueSelector<Solution_> leftValueSelector = this.buildIterableValueSelector(configPolicy, entityDescriptor, valueSelectorConfig, minimumCacheType, selectionOrder);
        IterableValueSelector<Solution_> rightValueSelector = this.buildIterableValueSelector(configPolicy, entityDescriptor, secondaryValueSelectorConfig, minimumCacheType, selectionOrder);
        if (enableEntityValueRangeFilter) {
            rightValueSelector = ValueSelectorFactory.applyValueRangeFiltering(configPolicy, rightValueSelector, entityDescriptor, mimicSelectorId, minimumCacheType, selectionOrder, randomSelection, true);
        }
        if ((variableDescriptor = leftValueSelector.getVariableDescriptor()) != rightValueSelector.getVariableDescriptor()) {
            throw new IllegalStateException("Impossible state: the leftValueSelector (%s) and the rightValueSelector (%s) have different variable descriptors. This should have failed fast during config unfolding.".formatted(leftValueSelector, rightValueSelector));
        }
        return new ListSwapMoveSelector<Solution_>(leftValueSelector, rightValueSelector, randomSelection);
    }

    private IterableValueSelector<Solution_> buildIterableValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, ValueSelectorConfig valueSelectorConfig, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        return (IterableValueSelector)valueSelector;
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlySecondaryVariableDescriptor;
        GenuineVariableDescriptor onlyVariableDescriptor;
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptorWithListVariable(configPolicy.getSolutionDescriptor());
        GenuineVariableDescriptor genuineVariableDescriptor = onlyVariableDescriptor = ((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor);
        if (((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig() != null && onlyVariableDescriptor != (onlySecondaryVariableDescriptor = ValueSelectorFactory.create(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor))) {
            throw new IllegalArgumentException("The valueSelector (%s)'s variableName (%s) and secondaryValueSelectorConfig (%s)'s variableName (%s) must be the same planning list variable.".formatted(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig(), onlyVariableDescriptor == null ? null : onlyVariableDescriptor.getVariableName(), ((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig(), onlySecondaryVariableDescriptor == null ? null : onlySecondaryVariableDescriptor.getVariableName()));
        }
        if (onlyVariableDescriptor != null) {
            if (!onlyVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("Impossible state: the listSwapMoveSelector (%s) is configured to use a planning variable (%s), which is not a planning list variable. Either fix your annotations and use a @%s on the variable to make it work with listSwapMoveSelector or use a swapMoveSelector instead.".formatted(this.config, onlyVariableDescriptor, PlanningListVariable.class.getSimpleName()));
            }
            return null;
        }
        List<ListVariableDescriptor<Solution_>> variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList().stream().filter(VariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).toList();
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("Impossible state: the listSwapMoveSelector (%s) cannot unfold because there are no planning list variables for the only entity (%s) or no planning list variables at all.".formatted(this.config, entityDescriptor));
        }
        return this.buildUnfoldedMoveSelectorConfig(variableDescriptorList);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(List<ListVariableDescriptor<Solution_>> variableDescriptorList) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
        for (ListVariableDescriptor<Solution_> variableDescriptor : variableDescriptorList) {
            ListSwapMoveSelectorConfig childMoveSelectorConfig = new ListSwapMoveSelectorConfig();
            ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig());
            if (childValueSelectorConfig.getMimicSelectorRef() == null) {
                childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
            }
            childMoveSelectorConfig.setValueSelectorConfig(childValueSelectorConfig);
            if (((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig() != null) {
                ValueSelectorConfig childSecondaryValueSelectorConfig = new ValueSelectorConfig(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig());
                if (childSecondaryValueSelectorConfig.getMimicSelectorRef() == null) {
                    childSecondaryValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
                }
                childMoveSelectorConfig.setSecondaryValueSelectorConfig(childSecondaryValueSelectorConfig);
            }
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }
}

