/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.nextprev;

import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractNextPrevElementShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    protected ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    protected AbstractNextPrevElementShadowVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
    }

    abstract String getSourceVariableName();

    abstract String getAnnotationName();

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.linkShadowSources(descriptorPolicy);
    }

    private void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        String sourceVariableName = this.getSourceVariableName();
        List entitiesWithSourceVariable = this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors().stream().filter(entityDescriptor -> entityDescriptor.hasVariableDescriptor(sourceVariableName)).collect(Collectors.toList());
        if (entitiesWithSourceVariable.isEmpty()) {
            throw new IllegalArgumentException("The entityClass (" + String.valueOf(this.entityDescriptor.getEntityClass()) + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on any of the entity classes (" + String.valueOf(this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors()) + ").");
        }
        if (entitiesWithSourceVariable.size() > 1) {
            throw new IllegalArgumentException("The entityClass (" + String.valueOf(this.entityDescriptor.getEntityClass()) + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a unique planning variable. A planning variable with the name (" + sourceVariableName + ") exists on multiple entity classes (" + String.valueOf(entitiesWithSourceVariable) + ").");
        }
        VariableDescriptor variableDescriptor = ((EntityDescriptor)entitiesWithSourceVariable.get(0)).getVariableDescriptor(sourceVariableName);
        if (variableDescriptor == null) {
            throw new IllegalStateException("Impossible state: variableDescriptor (" + String.valueOf(variableDescriptor) + ") is null but previous checks indicate that the entityClass (" + String.valueOf(entitiesWithSourceVariable.get(0)) + ") has a planning variable with sourceVariableName (" + sourceVariableName + ").");
        }
        if (!(variableDescriptor instanceof ListVariableDescriptor)) {
            throw new IllegalArgumentException("The entityClass (" + String.valueOf(this.entityDescriptor.getEntityClass()) + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        this.sourceVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
        if (!this.variableMemberAccessor.getType().equals(this.sourceVariableDescriptor.getElementType())) {
            throw new IllegalStateException("The entityClass (" + String.valueOf(this.entityDescriptor.getEntityClass()) + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") of type (" + String.valueOf(this.variableMemberAccessor.getType()) + ") which is not the type of elements (" + String.valueOf(this.sourceVariableDescriptor.getElementType()) + ") of the source list variable (" + String.valueOf(this.sourceVariableDescriptor) + ").");
        }
        this.sourceVariableDescriptor.registerSinkVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Demand<?> getProvidedDemand() {
        throw new UnsupportedOperationException("Impossible state: Handled by %s.".formatted(ListVariableStateSupply.class.getSimpleName()));
    }

    @Override
    public boolean isListVariableSource() {
        return true;
    }
}

