/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.InverseRelationShadowVariable;
import ai.timefold.solver.core.api.domain.variable.NextElementShadowVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningVariableGraphType;
import ai.timefold.solver.core.api.domain.variable.PreviousElementShadowVariable;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.declarative.ParentVariableType;
import ai.timefold.solver.core.impl.domain.variable.declarative.PathPart;
import ai.timefold.solver.core.impl.domain.variable.declarative.PathPartIterator;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.variable.declarative.ShadowSources;
import ai.timefold.solver.core.preview.api.domain.variable.declarative.ShadowVariableLooped;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record RootVariableSource<Entity_, Value_>(Class<? extends Entity_> rootEntity, List<MemberAccessor> listMemberAccessors, BiConsumer<Object, Consumer<Value_>> valueEntityFunction, List<VariableSourceReference> variableSourceReferences, String variablePath, ParentVariableType parentVariableType, @Nullable ParentVariableType groupParentVariableType) {
    public static final String COLLECTION_REFERENCE_SUFFIX = "[]";
    public static final String MEMBER_SEPERATOR_REGEX = "\\.";

    public static Iterator<PathPart> pathIterator(Class<?> rootEntity, String path) {
        String[] parts = path.split(MEMBER_SEPERATOR_REGEX);
        return new PathPartIterator(rootEntity, parts, path);
    }

    public static <Entity_, Value_> RootVariableSource<Entity_, Value_> from(PlanningSolutionMetaModel<?> solutionMetaModel, Class<? extends Entity_> rootEntityClass, String targetVariableName, String variablePath, MemberAccessorFactory memberAccessorFactory, DescriptorPolicy descriptorPolicy) {
        BiConsumer<Object, Consumer<Value_>> valueEntityFunction;
        ArrayList<MemberAccessor> chainStartingFromSourceVariable;
        ArrayList<MemberAccessor> chainToVariable = new ArrayList<MemberAccessor>();
        ArrayList<MemberAccessor> listMemberAccessors = new ArrayList<MemberAccessor>();
        boolean hasListMemberAccessor = false;
        ArrayList<ArrayList<MemberAccessor>> chainStartingFromSourceVariableList = new ArrayList<ArrayList<MemberAccessor>>();
        boolean isAfterVariable = false;
        Class<Object> currentEntity = rootEntityClass;
        int factCountSinceLastVariable = 0;
        ParentVariableType parentVariableType = null;
        ParentVariableType groupParentVariableType = null;
        Iterator<PathPart> iterator = RootVariableSource.pathIterator(rootEntityClass, variablePath);
        while (iterator.hasNext()) {
            MemberAccessor memberAccessor;
            PathPart pathPart = iterator.next();
            if (pathPart.isCollection()) {
                if (isAfterVariable) {
                    throw new IllegalArgumentException("The source path (%s) starting from root class (%s) accesses a collection (%s[]) after a variable (%s), which is not allowed.".formatted(variablePath, rootEntityClass.getSimpleName(), pathPart.name(), ((MemberAccessor)((List)chainStartingFromSourceVariableList.get(0)).get(0)).getName()));
                }
                if (hasListMemberAccessor) {
                    throw new IllegalArgumentException("The source path (%s) starting from root class (%s) accesses a collection (%s[]) after another collection (%s), which is not allowed.".formatted(variablePath, rootEntityClass.getSimpleName(), pathPart.name(), ((MemberAccessor)listMemberAccessors.get(listMemberAccessors.size() - 1)).getName()));
                }
                memberAccessor = RootVariableSource.getMemberAccessor(pathPart.member(), memberAccessorFactory, descriptorPolicy);
                listMemberAccessors.add(memberAccessor);
                chainToVariable = new ArrayList();
                factCountSinceLastVariable = 0;
                currentEntity = ConfigUtils.extractGenericTypeParameterOrFail(ShadowSources.class.getSimpleName(), currentEntity, memberAccessor.getType(), memberAccessor.getGenericType(), ShadowSources.class, memberAccessor.getName());
                parentVariableType = ParentVariableType.GROUP;
                hasListMemberAccessor = true;
                continue;
            }
            memberAccessor = RootVariableSource.getMemberAccessor(pathPart.member(), memberAccessorFactory, descriptorPolicy);
            if (!hasListMemberAccessor) {
                listMemberAccessors.add(memberAccessor);
            }
            boolean isVariable = RootVariableSource.isVariable(solutionMetaModel, memberAccessor.getDeclaringClass(), pathPart.name());
            chainToVariable.add(memberAccessor);
            for (List list : chainStartingFromSourceVariableList) {
                list.add(memberAccessor);
            }
            if (isVariable) {
                chainStartingFromSourceVariable = new ArrayList<MemberAccessor>();
                chainStartingFromSourceVariable.add(memberAccessor);
                chainStartingFromSourceVariableList.add(chainStartingFromSourceVariable);
                isAfterVariable = true;
                factCountSinceLastVariable = 0;
                if (parentVariableType == null) {
                    parentVariableType = RootVariableSource.determineParentVariableType(rootEntityClass, variablePath, chainToVariable, memberAccessor);
                }
                if (hasListMemberAccessor && groupParentVariableType == null) {
                    groupParentVariableType = RootVariableSource.determineParentVariableType(rootEntityClass, variablePath, chainToVariable, memberAccessor);
                }
            } else if (++factCountSinceLastVariable == 2) {
                throw new IllegalArgumentException("The source path (%s) starting from root entity (%s) referencing multiple facts (%s, %s) in a row.".formatted(variablePath, rootEntityClass.getSimpleName(), ((MemberAccessor)chainToVariable.get(chainToVariable.size() - 2)).getName(), ((MemberAccessor)chainToVariable.get(chainToVariable.size() - 1)).getName()));
            }
            currentEntity = memberAccessor.getType();
        }
        List<MemberAccessor> chainToVariableEntity = chainToVariable.subList(0, chainToVariable.size() - 1);
        if (!hasListMemberAccessor) {
            valueEntityFunction = RootVariableSource.getRegularSourceEntityVisitor(chainToVariableEntity);
            listMemberAccessors.clear();
        } else {
            valueEntityFunction = RootVariableSource.getCollectionSourceEntityVisitor(listMemberAccessors, chainToVariableEntity);
        }
        ArrayList<VariableSourceReference> variableSourceReferences = new ArrayList<VariableSourceReference>();
        for (int i = 0; i < chainStartingFromSourceVariableList.size(); ++i) {
            chainStartingFromSourceVariable = (ArrayList<MemberAccessor>)chainStartingFromSourceVariableList.get(i);
            VariableSourceReference variableSourceReference = RootVariableSource.createVariableSourceReferenceFromChain(variablePath, variableSourceReferences, listMemberAccessors, solutionMetaModel, rootEntityClass, targetVariableName, chainStartingFromSourceVariable, chainToVariable, i == 0, i == chainStartingFromSourceVariableList.size() - 1);
            variableSourceReferences.add(variableSourceReference);
        }
        if (variableSourceReferences.isEmpty()) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) does not reference any variables.".formatted(variablePath, rootEntityClass.getSimpleName()));
        }
        if (factCountSinceLastVariable != 0) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) does not end on a variable.".formatted(variablePath, rootEntityClass.getSimpleName()));
        }
        for (VariableSourceReference variableSourceReference : variableSourceReferences) {
            RootVariableSource.assertIsValidVariableReference(rootEntityClass, variablePath, variableSourceReference);
        }
        if (!parentVariableType.isIndirect() && variableSourceReferences.size() == 1) {
            parentVariableType = ParentVariableType.NO_PARENT;
        }
        if (!parentVariableType.isIndirect() && chainToVariable.size() > 2) {
            parentVariableType = ParentVariableType.INDIRECT;
        }
        return new RootVariableSource<Entity_, Value_>(rootEntityClass, listMemberAccessors, valueEntityFunction, variableSourceReferences, variablePath, parentVariableType, groupParentVariableType);
    }

    public @NonNull BiConsumer<Object, Consumer<Object>> getEntityVisitor(List<MemberAccessor> chainToEntity) {
        if (this.listMemberAccessors.isEmpty()) {
            return RootVariableSource.getRegularSourceEntityVisitor(chainToEntity);
        }
        return RootVariableSource.getCollectionSourceEntityVisitor(this.listMemberAccessors, chainToEntity);
    }

    private static <Value_> @NonNull BiConsumer<Object, Consumer<Value_>> getRegularSourceEntityVisitor(List<MemberAccessor> finalChainToVariable) {
        return (entity, consumer) -> {
            Object current = entity;
            for (MemberAccessor accessor : finalChainToVariable) {
                current = accessor.executeGetter(current);
                if (current != null) continue;
                return;
            }
            consumer.accept(current);
        };
    }

    private static <Value_> @NonNull BiConsumer<Object, Consumer<Value_>> getCollectionSourceEntityVisitor(List<MemberAccessor> listMemberAccessors, List<MemberAccessor> finalChainToVariable) {
        BiConsumer entityListMemberAccessor = RootVariableSource.getRegularSourceEntityVisitor(listMemberAccessors);
        BiConsumer elementSourceEntityVisitor = RootVariableSource.getRegularSourceEntityVisitor(finalChainToVariable);
        return (entity, consumer) -> entityListMemberAccessor.accept(entity, iterable -> {
            for (Object item : iterable) {
                elementSourceEntityVisitor.accept(item, (Consumer)consumer);
            }
        });
    }

    private static <Entity_> @NonNull VariableSourceReference createVariableSourceReferenceFromChain(String variablePath, List<VariableSourceReference> variableSourceReferences, List<MemberAccessor> listMemberAccessors, PlanningSolutionMetaModel<?> solutionMetaModel, Class<? extends Entity_> rootEntityClass, String targetVariableName, List<MemberAccessor> afterChain, List<MemberAccessor> chainToVariable, boolean isTopLevel, boolean isBottomLevel) {
        boolean isDeclarative;
        MemberAccessor variableMemberAccessor = afterChain.get(0);
        VariablePath sourceVariablePath = new VariablePath(variableMemberAccessor.getDeclaringClass(), variableMemberAccessor.getName(), chainToVariable.subList(0, chainToVariable.size() - afterChain.size()), afterChain);
        VariableMetaModel downstreamDeclarativeVariable = null;
        MemberAccessor maybeDownstreamVariable = afterChain.remove(afterChain.size() - 1);
        if (RootVariableSource.isDeclarativeShadowVariable(maybeDownstreamVariable)) {
            downstreamDeclarativeVariable = solutionMetaModel.entity(maybeDownstreamVariable.getDeclaringClass()).variable(maybeDownstreamVariable.getName());
        }
        if (!(isDeclarative = RootVariableSource.isDeclarativeShadowVariable(variableMemberAccessor))) {
            for (VariableSourceReference previousVariableSourceReference : variableSourceReferences) {
                if (previousVariableSourceReference.isDeclarative()) continue;
                throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) accesses a non-declarative shadow variable (%s) after another non-declarative shadow variable (%s).".formatted(variablePath, rootEntityClass.getSimpleName(), variableMemberAccessor.getName(), previousVariableSourceReference.variableMetaModel().name()));
            }
        }
        return new VariableSourceReference(solutionMetaModel.entity(variableMemberAccessor.getDeclaringClass()).variable(variableMemberAccessor.getName()), sourceVariablePath.memberAccessorsBeforeEntity, isTopLevel && sourceVariablePath.memberAccessorsBeforeEntity.isEmpty() && listMemberAccessors.isEmpty(), isTopLevel, isBottomLevel, isDeclarative, solutionMetaModel.entity(rootEntityClass).variable(targetVariableName), downstreamDeclarativeVariable, sourceVariablePath::findTargetEntity);
    }

    private static void assertIsValidVariableReference(Class<?> rootEntityClass, String variablePath, VariableSourceReference variableSourceReference) {
        VariableMetaModel<?, ?, ?> sourceVariableId = variableSourceReference.variableMetaModel();
        if (variableSourceReference.isDeclarative() && variableSourceReference.downstreamDeclarativeVariableMetamodel() != null && !variableSourceReference.isBottomLevel()) {
            throw new IllegalArgumentException("The source path (%s) starting from root entity class (%s) accesses a declarative shadow variable (%s) from another declarative shadow variable (%s).".formatted(variablePath, rootEntityClass.getSimpleName(), variableSourceReference.downstreamDeclarativeVariableMetamodel().name(), sourceVariableId.name()));
        }
    }

    public static Member getMember(Class<?> rootClass, String sourcePath, Class<?> declaringClass, String memberName) {
        Class<?> methodType;
        Field field = ReflectionHelper.getDeclaredField(declaringClass, memberName);
        Method getterMethod = ReflectionHelper.getDeclaredGetterMethod(declaringClass, memberName);
        if (field == null && getterMethod == null) {
            throw new IllegalArgumentException("The source path (%s) starting from root class (%s) references a member (%s) on class (%s) that does not exist.".formatted(sourcePath, rootClass.getSimpleName(), memberName, declaringClass.getSimpleName()));
        }
        if (field != null && getterMethod == null) {
            return field;
        }
        if (field == null) {
            return getterMethod;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.equals(methodType = getterMethod.getReturnType())) {
            return getterMethod;
        }
        if (fieldType.isAssignableFrom(methodType)) {
            return getterMethod;
        }
        if (methodType.isAssignableFrom(fieldType)) {
            return field;
        }
        return getterMethod;
    }

    private static MemberAccessor getMemberAccessor(Member member, MemberAccessorFactory memberAccessorFactory, DescriptorPolicy descriptorPolicy) {
        return memberAccessorFactory.buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD, descriptorPolicy.getDomainAccessType());
    }

    public static boolean isVariable(PlanningSolutionMetaModel<?> metaModel, Class<?> declaringClass, String memberName) {
        if (!metaModel.hasEntity(declaringClass)) {
            return false;
        }
        return metaModel.entity(declaringClass).hasVariable(memberName);
    }

    private static ParentVariableType determineParentVariableType(Class<?> rootClass, String variablePath, List<MemberAccessor> chain, MemberAccessor memberAccessor) {
        boolean isIndirect = chain.size() > 1;
        Class<?> declaringClass = memberAccessor.getDeclaringClass();
        String memberName = memberAccessor.getName();
        if (isIndirect) {
            return ParentVariableType.INDIRECT;
        }
        if (RootVariableSource.getAnnotation(declaringClass, memberName, PreviousElementShadowVariable.class) != null) {
            return ParentVariableType.PREVIOUS;
        }
        if (RootVariableSource.getAnnotation(declaringClass, memberName, NextElementShadowVariable.class) != null) {
            return ParentVariableType.NEXT;
        }
        if (RootVariableSource.getAnnotation(declaringClass, memberName, InverseRelationShadowVariable.class) != null) {
            String variableName;
            InverseRelationShadowVariable inverseVariable = Objects.requireNonNull(RootVariableSource.getAnnotation(declaringClass, memberName, InverseRelationShadowVariable.class));
            Class<?> sourceClass = memberAccessor.getType();
            PlanningVariable sourcePlanningVariable = RootVariableSource.getAnnotation(sourceClass, variableName = inverseVariable.sourceVariableName(), PlanningVariable.class);
            if (sourcePlanningVariable == null) {
                return ParentVariableType.INVERSE;
            }
            if (sourcePlanningVariable.graphType() == PlanningVariableGraphType.CHAINED) {
                return ParentVariableType.CHAINED_NEXT;
            }
            return ParentVariableType.INVERSE;
        }
        if (RootVariableSource.getAnnotation(declaringClass, memberName, PlanningVariable.class) != null) {
            return ParentVariableType.VARIABLE;
        }
        if (RootVariableSource.getAnnotation(declaringClass, memberName, ShadowVariableLooped.class) != null) {
            throw new IllegalArgumentException("The source path (%s) starting from root class (%s) accesses a @%s property (%s).\nSupplier methods are only called when none of their dependencies are looped,\nso reading @%s properties are not needed since they are guaranteed to be false\nwhen the supplier is called.\nMaybe remove the source path (%s) from the @%s?\n".formatted(variablePath, rootClass.getCanonicalName(), ShadowVariableLooped.class.getSimpleName(), memberName, ShadowVariableLooped.class.getSimpleName(), variablePath, ShadowSources.class.getSimpleName()));
        }
        return ParentVariableType.NO_PARENT;
    }

    private static <T extends Annotation> @Nullable T getAnnotation(Class<?> declaringClass, String memberName, Class<? extends T> annotationClass) {
        for (Class<?> currentClass = declaringClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field field = ReflectionHelper.getDeclaredField(currentClass, memberName);
            Method getterMethod = ReflectionHelper.getDeclaredGetterMethod(currentClass, memberName);
            if (field != null && field.getAnnotation(annotationClass) != null) {
                return field.getAnnotation(annotationClass);
            }
            if (getterMethod == null || getterMethod.getAnnotation(annotationClass) == null) continue;
            return getterMethod.getAnnotation(annotationClass);
        }
        return null;
    }

    private static boolean isDeclarativeShadowVariable(MemberAccessor memberAccessor) {
        ShadowVariable shadowVariable = RootVariableSource.getAnnotation(memberAccessor.getDeclaringClass(), memberAccessor.getName(), ShadowVariable.class);
        if (shadowVariable == null) {
            return false;
        }
        return !shadowVariable.supplierName().isEmpty();
    }

    @Override
    public @NonNull String toString() {
        return this.variablePath;
    }

    private record VariablePath(Class<?> variableEntityClass, String variableName, List<MemberAccessor> memberAccessorsBeforeEntity, List<MemberAccessor> memberAccessorsAfterEntity) {
        public @Nullable Object findTargetEntity(Object entity) {
            Object currentEntity = entity;
            for (MemberAccessor member : this.memberAccessorsAfterEntity) {
                currentEntity = member.executeGetter(currentEntity);
                if (currentEntity != null) continue;
                return null;
            }
            return currentEntity;
        }
    }
}

