/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.AbstractVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.PriorityQueue;
import java.util.function.IntFunction;
import org.jspecify.annotations.NonNull;

public final class FixedVariableReferenceGraph<Solution_>
extends AbstractVariableReferenceGraph<Solution_, PriorityQueue<BaseTopologicalOrderGraph.NodeTopologicalOrder>> {
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private boolean isFinalized = false;

    public FixedVariableReferenceGraph(VariableReferenceGraphBuilder<Solution_> outerGraph, IntFunction<TopologicalOrderGraph> graphCreator) {
        super(outerGraph, graphCreator);
        this.graph.commitChanges(new BitSet(this.nodeList.size()));
        this.isFinalized = true;
        for (int node = 0; node < this.nodeList.size(); ++node) {
            ((PriorityQueue)this.changeSet).add(this.graph.getTopologicalOrder(node));
        }
        this.changedVariableNotifier = outerGraph.changedVariableNotifier;
    }

    @Override
    protected PriorityQueue<BaseTopologicalOrderGraph.NodeTopologicalOrder> createChangeSet(int instanceCount) {
        return new PriorityQueue<BaseTopologicalOrderGraph.NodeTopologicalOrder>(instanceCount);
    }

    @Override
    public void markChanged(@NonNull GraphNode<Solution_> node) {
        if (this.isFinalized) {
            ((PriorityQueue)this.changeSet).add(this.graph.getTopologicalOrder(node.graphNodeId()));
        }
    }

    @Override
    public void updateChanged() {
        BitSet visited;
        if (!((PriorityQueue)this.changeSet).isEmpty()) {
            visited = new BitSet(this.nodeList.size());
            visited.set(((BaseTopologicalOrderGraph.NodeTopologicalOrder)((PriorityQueue)this.changeSet).peek()).nodeId());
        } else {
            return;
        }
        while (!((PriorityQueue)this.changeSet).isEmpty()) {
            BaseTopologicalOrderGraph.NodeTopologicalOrder changedNode = (BaseTopologicalOrderGraph.NodeTopologicalOrder)((PriorityQueue)this.changeSet).poll();
            GraphNode entityVariable = (GraphNode)this.nodeList.get(changedNode.nodeId());
            Object entity = entityVariable.entity();
            List shadowVariableReferences = entityVariable.variableReferences();
            for (VariableUpdaterInfo<Solution_> shadowVariableReference : shadowVariableReferences) {
                boolean isVariableChanged = shadowVariableReference.updateIfChanged(entity, this.changedVariableNotifier);
                if (!isVariableChanged) continue;
                PrimitiveIterator.OfInt iterator = this.graph.nodeForwardEdges(changedNode.nodeId());
                while (iterator.hasNext()) {
                    Integer nextNode = iterator.next();
                    if (visited.get(nextNode)) continue;
                    visited.set(nextNode);
                    ((PriorityQueue)this.changeSet).add(this.graph.getTopologicalOrder(nextNode));
                }
            }
        }
    }
}

