/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset;

import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.move.streams.FromSolutionValueCollectingFunction;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataset;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.ForEachExcludingPinnedDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.ForEachFromSolutionDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.ForEachIncludingPinnedDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.TerminalUniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DataStreamFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Map<AbstractDataStream<Solution_>, AbstractDataStream<Solution_>> sharingStreamMap = new HashMap<AbstractDataStream<Solution_>, AbstractDataStream<Solution_>>(256);

    public DataStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public <A> UniDataStream<Solution_, A> forEachNonDiscriminating(Class<A> sourceClass) {
        this.assertValidForEachType(sourceClass);
        return this.share(new ForEachIncludingPinnedDataStream(this, sourceClass));
    }

    public <A> UniDataStream<Solution_, A> forEachExcludingPinned(Class<A> sourceClass) {
        this.assertValidForEachType(sourceClass);
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null || !listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.share(new ForEachExcludingPinnedDataStream<Solution_, A>(this, this.solutionDescriptor.getMetaModel().entity(sourceClass)));
        }
        EntityDescriptor parentEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
        if (!parentEntityDescriptor.supportsPinning()) {
            throw new UnsupportedOperationException("Impossible state: the list variable (%s) does not support pinning.".formatted(listVariableDescriptor.getVariableName()));
        }
        UniDataStream<Solution_, A> stream = this.forEachNonDiscriminating(sourceClass).ifNotExists(parentEntityDescriptor.getEntityClass(), Joiners.filtering(listVariableDescriptor.getEntityContainsPinnedValuePredicate()));
        return this.share((AbstractUniDataStream)stream);
    }

    public <A> UniDataStream<Solution_, A> forEachFromSolution(FromSolutionValueCollectingFunction<Solution_, A> valueCollectingFunction) {
        return this.share(new ForEachFromSolutionDataStream<Solution_, A>(this, valueCollectingFunction));
    }

    public <A> void assertValidForEachType(Class<A> fromType) {
        Set<Class<?>> problemFactOrEntityClassSet = this.solutionDescriptor.getProblemFactOrEntityClassSet();
        boolean hasMatchingType = problemFactOrEntityClassSet.stream().anyMatch(factType -> fromType.isAssignableFrom((Class<?>)factType) || factType.isAssignableFrom(fromType));
        if (!hasMatchingType) {
            List<String> canonicalClassNameList = problemFactOrEntityClassSet.stream().map(Class::getCanonicalName).sorted().toList();
            throw new IllegalArgumentException("Cannot use class (%s) in a data stream as it is neither the same as, nor a superclass or superinterface of one of planning entities or problem facts.\nEnsure that all forEach(), join(), ifExists() and ifNotExists() building blocks only reference classes assignable from planning entities or problem facts (%s) annotated on the planning solution (%s).".formatted(fromType.getCanonicalName(), canonicalClassNameList, this.solutionDescriptor.getSolutionClass().getCanonicalName()));
        }
    }

    public <Stream_ extends AbstractDataStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)this.share(stream, t -> {});
    }

    public <Stream_ extends AbstractDataStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        });
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public List<AbstractDataset<Solution_, ?>> getDatasets() {
        return this.sharingStreamMap.values().stream().flatMap(s -> {
            if (s instanceof TerminalUniDataStream) {
                TerminalUniDataStream terminalStream = (TerminalUniDataStream)s;
                return Stream.of(terminalStream.getDataset());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }
}

