/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.descriptor;

import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningVariableGraphType;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.MovableChainedTrailingValueFilter;

public final class BasicVariableDescriptor<Solution_>
extends GenuineVariableDescriptor<Solution_> {
    private SelectionFilter<Solution_, Object> movableChainedTrailingValueFilter;
    private boolean chained;
    private boolean allowsUnassigned;

    public BasicVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean allowsUnassigned() {
        return this.allowsUnassigned;
    }

    @Override
    protected void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variableMemberAccessor.getAnnotation(PlanningVariable.class);
        this.processAllowsUnassigned(planningVariableAnnotation);
        this.processChained(planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation.valueRangeProviderRefs());
        this.processStrength(planningVariableAnnotation.strengthComparatorClass(), planningVariableAnnotation.strengthWeightFactoryClass());
    }

    private void processAllowsUnassigned(PlanningVariable planningVariableAnnotation) {
        boolean deprecatedNullable = planningVariableAnnotation.nullable();
        if (planningVariableAnnotation.allowsUnassigned()) {
            if (deprecatedNullable) {
                throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) with allowsUnassigned (%s) and nullable (%s) which are mutually exclusive.".formatted(this.entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableMemberAccessor.getName(), true, true));
            }
            this.allowsUnassigned = true;
        } else {
            this.allowsUnassigned = deprecatedNullable;
        }
        if (this.allowsUnassigned && this.variableMemberAccessor.getType().isPrimitive()) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) with allowsUnassigned (%s) which is not compatible with the primitive propertyType (%s).".formatted(this.entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableMemberAccessor.getName(), this.allowsUnassigned, this.variableMemberAccessor.getType()));
        }
    }

    private void processChained(PlanningVariable planningVariableAnnotation) {
        boolean bl = this.chained = planningVariableAnnotation.graphType() == PlanningVariableGraphType.CHAINED;
        if (!this.chained) {
            return;
        }
        if (!this.acceptsValueType(this.entityDescriptor.getEntityClass())) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) with chained (%s) and propertyType (%s) which is not a superclass/interface of or the same as the entityClass (%s).\nIf an entity's chained planning variable cannot point to another entity of the same class, then it is impossible to make a chain longer than 1 entity and therefore chaining is useless.".formatted(this.entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableMemberAccessor.getName(), this.chained, this.getVariablePropertyType(), this.entityDescriptor.getEntityClass()));
        }
        if (this.allowsUnassigned) {
            throw new IllegalArgumentException("The entityClass (%s) has a @%s-annotated property (%s) with chained (%s), which is not compatible with nullable (%s).".formatted(this.entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), this.variableMemberAccessor.getName(), this.chained, this.allowsUnassigned));
        }
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        super.linkVariableDescriptors(descriptorPolicy);
        this.movableChainedTrailingValueFilter = this.chained && this.entityDescriptor.hasEffectiveMovableEntityFilter() ? new MovableChainedTrailingValueFilter(this) : null;
    }

    @Override
    public boolean acceptsValueType(Class<?> valueType) {
        return this.getVariablePropertyType().isAssignableFrom(valueType);
    }

    @Override
    public boolean isInitialized(Object entity) {
        return this.allowsUnassigned || this.getValue(entity) != null;
    }

    public boolean hasMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter != null;
    }

    public SelectionFilter<Solution_, Object> getMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter;
    }
}

