/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ParentVariableType;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public enum GraphStructure {
    EMPTY,
    NO_DYNAMIC_EDGES,
    SINGLE_DIRECTIONAL_PARENT,
    ARBITRARY_SINGLE_ENTITY_SINGLE_DIRECTIONAL_PARENT_TYPE,
    ARBITRARY;

    private static final Logger LOGGER;

    public static <Solution_> GraphStructureAndDirection determineGraphStructure(SolutionDescriptor<Solution_> solutionDescriptor, Object ... entities) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        if (declarativeShadowVariableDescriptors.isEmpty()) {
            return new GraphStructureAndDirection(EMPTY, null, null);
        }
        if (!GraphStructure.doEntitiesUseDeclarativeShadowVariables(declarativeShadowVariableDescriptors, entities)) {
            return new GraphStructureAndDirection(EMPTY, null, null);
        }
        boolean multipleDeclarativeEntityClasses = declarativeShadowVariableDescriptors.stream().map(variable -> variable.getEntityDescriptor().getEntityClass()).distinct().count() > 1L;
        GraphStructureAndDirection arbitraryGraphStructure = new GraphStructureAndDirection(multipleDeclarativeEntityClasses ? ARBITRARY : ARBITRARY_SINGLE_ENTITY_SINGLE_DIRECTIONAL_PARENT_TYPE, null, null);
        List rootVariableSources = declarativeShadowVariableDescriptors.stream().flatMap(descriptor -> Arrays.stream(descriptor.getSources())).toList();
        ParentVariableType directionalType = null;
        VariableMetaModel<?, ?, ?> parentMetaModel = null;
        boolean isArbitrary = multipleDeclarativeEntityClasses;
        block5: for (RootVariableSource variableSource : rootVariableSources) {
            ParentVariableType parentVariableType = variableSource.parentVariableType();
            LOGGER.trace("{} has parentVariableType {}", (Object)variableSource, (Object)parentVariableType);
            switch (parentVariableType) {
                case GROUP: {
                    MutableInt groupMemberCount = new MutableInt(0);
                    for (Object entity : entities) {
                        if (!variableSource.rootEntity().isInstance(entity)) continue;
                        variableSource.valueEntityFunction().accept(entity, fromEntity -> groupMemberCount.increment());
                    }
                    if (groupMemberCount.intValue() == 0) continue block5;
                    isArbitrary = true;
                    ParentVariableType groupParentVariableType = variableSource.groupParentVariableType();
                    if (groupParentVariableType == null || !groupParentVariableType.isDirectional()) continue block5;
                    VariableMetaModel<?, ?, ?> groupParentVariableMetamodel = variableSource.variableSourceReferences().get(0).variableMetaModel();
                    if (parentMetaModel == null) {
                        parentMetaModel = groupParentVariableMetamodel;
                        break;
                    }
                    if (parentMetaModel.equals(variableSource.variableSourceReferences().get(0).variableMetaModel())) continue block5;
                    return new GraphStructureAndDirection(ARBITRARY, null, null);
                }
                case INDIRECT: 
                case INVERSE: 
                case VARIABLE: 
                case CHAINED_NEXT: {
                    isArbitrary = true;
                    break;
                }
                case NEXT: 
                case PREVIOUS: {
                    if (parentMetaModel == null) {
                        parentMetaModel = variableSource.variableSourceReferences().get(0).variableMetaModel();
                        directionalType = parentVariableType;
                        break;
                    }
                    if (parentMetaModel.equals(variableSource.variableSourceReferences().get(0).variableMetaModel())) break;
                    return new GraphStructureAndDirection(ARBITRARY, null, null);
                }
            }
        }
        if (isArbitrary) {
            return arbitraryGraphStructure;
        }
        if (directionalType == null) {
            return new GraphStructureAndDirection(NO_DYNAMIC_EDGES, null, null);
        }
        return new GraphStructureAndDirection(SINGLE_DIRECTIONAL_PARENT, parentMetaModel, directionalType);
    }

    private static <Solution_> boolean doEntitiesUseDeclarativeShadowVariables(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Object ... entities) {
        boolean anyDeclarativeEntities = false;
        block0: for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable : declarativeShadowVariableDescriptors) {
            Class<?> entityClass = declarativeShadowVariable.getEntityDescriptor().getEntityClass();
            for (Object entity : entities) {
                if (entityClass.isInstance(entity)) {
                    anyDeclarativeEntities = true;
                    continue block0;
                }
                if (anyDeclarativeEntities) continue block0;
            }
        }
        return anyDeclarativeEntities;
    }

    static {
        LOGGER = LoggerFactory.getLogger(GraphStructure.class);
    }

    public record GraphStructureAndDirection(GraphStructure structure, @Nullable VariableMetaModel<?, ?, ?> parentMetaModel, @Nullable ParentVariableType direction) {
    }
}

