/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.util.MutableReference;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class EntityVariableUpdaterLookup<Solution_> {
    private final Map<VariableMetaModel<?, ?, ?>, Lookup<Solution_>> variableToEntityLookup = new LinkedHashMap();
    private final Supplier<Lookup<Solution_>> entityLookupSupplier;
    private int nextId = 0;

    private EntityVariableUpdaterLookup(Supplier<Lookup<Solution_>> entityLookupSupplier) {
        this.entityLookupSupplier = entityLookupSupplier;
    }

    public static <Solution_> EntityVariableUpdaterLookup<Solution_> entityIndependentLookup() {
        Supplier<Lookup<Solution_>> lookupSupplier = () -> {
            MutableReference<Object> sharedValue = new MutableReference<Object>(null);
            return new Lookup(ignored -> (List)sharedValue.getValue(), (ignored, valueSupplier) -> {
                if (sharedValue.getValue() == null) {
                    sharedValue.setValue(((List)valueSupplier.get()));
                }
            });
        };
        return new EntityVariableUpdaterLookup<Solution_>(lookupSupplier);
    }

    public static <Solution_> EntityVariableUpdaterLookup<Solution_> entityDependentLookup() {
        Supplier<Lookup<Solution_>> lookupSupplier = () -> {
            IdentityHashMap valueMap = new IdentityHashMap();
            return new Lookup(valueMap::get, (entity, valueSupplier) -> valueMap.computeIfAbsent(entity, arg_0 -> EntityVariableUpdaterLookup.lambda$entityDependentLookup$3((Supplier)valueSupplier, arg_0)));
        };
        return new EntityVariableUpdaterLookup<Solution_>(lookupSupplier);
    }

    public List<VariableUpdaterInfo<Solution_>> computeUpdatersForVariableOnEntity(VariableMetaModel<?, ?, ?> variableMetaModel, Object entity, Supplier<List<VariableUpdaterInfo<Solution_>>> updatersSupplier) {
        Lookup entityLookup = this.variableToEntityLookup.computeIfAbsent(variableMetaModel, ignored -> this.entityLookupSupplier.get());
        entityLookup.setUpdaters(entity, updatersSupplier);
        return entityLookup.getUpdaters(entity);
    }

    public int getNextId() {
        return this.nextId++;
    }

    private static /* synthetic */ List lambda$entityDependentLookup$3(Supplier valueSupplier, Object ignored) {
        return (List)valueSupplier.get();
    }

    private record Lookup<Solution_>(Function<Object, List<VariableUpdaterInfo<Solution_>>> getter, BiConsumer<Object, Supplier<List<VariableUpdaterInfo<Solution_>>>> setter) {
        List<VariableUpdaterInfo<Solution_>> getUpdaters(Object entity) {
            return this.getter.apply(entity);
        }

        void setUpdaters(Object entity, Supplier<List<VariableUpdaterInfo<Solution_>>> updatersSupplier) {
            this.setter.accept(entity, updatersSupplier);
        }
    }
}

