/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.placer;

import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.constructionheuristic.placer.AbstractEntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedEntityPlacer;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class QueuedEntityPlacerFactory<Solution_>
extends AbstractEntityPlacerFactory<Solution_, QueuedEntityPlacerConfig> {
    public static <Solution_> QueuedEntityPlacerConfig unfoldNew(HeuristicConfigPolicy<Solution_> configPolicy, List<MoveSelectorConfig> templateMoveSelectorConfigList) {
        QueuedEntityPlacerConfig config = new QueuedEntityPlacerConfig();
        EntitySelectorConfig entitySelectorConfig = new QueuedEntityPlacerFactory<Solution_>(config).buildEntitySelectorConfig(configPolicy);
        config.setEntitySelectorConfig(entitySelectorConfig);
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size());
        config.setMoveSelectorConfigList(moveSelectorConfigList);
        ArrayList<MoveSelectorConfig> leafMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size());
        for (MoveSelectorConfig moveSelectorConfig : templateMoveSelectorConfigList) {
            MoveSelectorConfig moveSelectorConfig2 = (MoveSelectorConfig)moveSelectorConfig.copyConfig();
            moveSelectorConfig2.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
            moveSelectorConfigList.add(moveSelectorConfig2);
        }
        for (MoveSelectorConfig<Object> moveSelectorConfig : leafMoveSelectorConfigList) {
            if (!(moveSelectorConfig instanceof ChangeMoveSelectorConfig)) {
                throw new IllegalStateException("The <constructionHeuristic> contains a moveSelector (%s) that isn't a <changeMoveSelector>, a <unionMoveSelector> or a <cartesianProductMoveSelector>.\nMaybe you're using a moveSelector in <constructionHeuristic> that's only supported for <localSearch>.".formatted(moveSelectorConfig));
            }
            ChangeMoveSelectorConfig changeMoveSelectorConfig = (ChangeMoveSelectorConfig)moveSelectorConfig;
            EntitySelectorConfig changeMoveEntitySelectorConfig = changeMoveSelectorConfig.getEntitySelectorConfig();
            if (changeMoveEntitySelectorConfig != null) {
                throw new IllegalStateException("The <constructionHeuristic> contains a changeMoveSelector (%s) that contains an entitySelector (%s) without explicitly configuring the <queuedEntityPlacer>.".formatted(changeMoveSelectorConfig, changeMoveEntitySelectorConfig));
            }
            changeMoveSelectorConfig.setEntitySelectorConfig(EntitySelectorConfig.newMimicSelectorConfig(entitySelectorConfig.getId()));
        }
        return config;
    }

    public QueuedEntityPlacerFactory(QueuedEntityPlacerConfig placerConfig) {
        super(placerConfig);
    }

    @Override
    public QueuedEntityPlacer<Solution_> buildEntityPlacer(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntitySelectorConfig entitySelectorConfig_ = this.buildEntitySelectorConfig(configPolicy);
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig_).buildEntitySelector(configPolicy, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL);
        List<MoveSelectorConfig> moveSelectorConfigList_ = this.getMoveSelectorConfigs(configPolicy, entitySelector, entitySelectorConfig_);
        ArrayList moveSelectorList = new ArrayList(moveSelectorConfigList_.size());
        for (MoveSelectorConfig moveSelectorConfig : moveSelectorConfigList_) {
            MoveSelector moveSelector = MoveSelectorFactory.create(moveSelectorConfig).buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL, false);
            moveSelectorList.add(moveSelector);
        }
        return new QueuedEntityPlacer<Solution_>(this, configPolicy, entitySelector, moveSelectorList);
    }

    private @NonNull List<MoveSelectorConfig> getMoveSelectorConfigs(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, EntitySelectorConfig entitySelectorConfig_) {
        List<MoveSelectorConfig> moveSelectorConfigList = ((QueuedEntityPlacerConfig)this.config).getMoveSelectorConfigList();
        if (!ConfigUtils.isEmptyCollection(moveSelectorConfigList)) {
            return moveSelectorConfigList;
        }
        EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
        List<GenuineVariableDescriptor> variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList().stream().filter(variableDescriptor -> !variableDescriptor.isListVariable()).toList();
        ArrayList<MoveSelectorConfig> subMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
        for (GenuineVariableDescriptor variableDescriptor2 : variableDescriptorList) {
            subMoveSelectorConfigList.add(this.buildChangeMoveSelectorConfig(configPolicy, entitySelectorConfig_.getId(), variableDescriptor2));
        }
        if (subMoveSelectorConfigList.size() > 1) {
            return Collections.singletonList(new CartesianProductMoveSelectorConfig(subMoveSelectorConfigList));
        }
        return Collections.singletonList((MoveSelectorConfig)subMoveSelectorConfigList.get(0));
    }

    public EntitySelectorConfig buildEntitySelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntitySelectorConfig entitySelectorConfig = ((QueuedEntityPlacerConfig)this.config).getEntitySelectorConfig();
        if (entitySelectorConfig == null) {
            entityDescriptor = this.getTheOnlyEntityDescriptorWithBasicVariables(configPolicy.getSolutionDescriptor());
            entitySelectorConfig = QueuedEntityPlacerFactory.getDefaultEntitySelectorConfigForEntity(configPolicy, entityDescriptor);
        } else {
            entityDescriptor = this.deduceEntityDescriptor(configPolicy, entitySelectorConfig.getEntityClass());
            entitySelectorConfig = QueuedEntityPlacerFactory.deduceEntitySortManner(configPolicy, entityDescriptor, entitySelectorConfig);
        }
        SelectionCacheType cacheType = entitySelectorConfig.getCacheType();
        if (cacheType != null && cacheType.compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The queuedEntityPlacer (%s) cannot have an entitySelectorConfig (%s) with a cacheType (%s) lower than %s.".formatted(new Object[]{this.config, entitySelectorConfig, cacheType, SelectionCacheType.PHASE}));
        }
        return entitySelectorConfig;
    }
}

