/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedAssignment;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.impl.domain.variable.ShadowVariableUpdateHelper;
import ai.timefold.solver.core.impl.solver.DefaultSolutionManager;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SolutionManager<Solution_, Score_ extends Score<Score_>> {
    public static <Solution_, Score_ extends Score<Score_>> @NonNull SolutionManager<Solution_, Score_> create(@NonNull SolverFactory<Solution_> solverFactory) {
        return new DefaultSolutionManager(solverFactory);
    }

    public static <Solution_, Score_ extends Score<Score_>, ProblemId_> @NonNull SolutionManager<Solution_, Score_> create(@NonNull SolverManager<Solution_, ProblemId_> solverManager) {
        return new DefaultSolutionManager(solverManager);
    }

    default public @Nullable Score_ update(@NonNull Solution_ solution) {
        return this.update(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public @Nullable Score_ update(@NonNull Solution_ var1, @NonNull SolutionUpdatePolicy var2);

    public static <Solution_> void updateShadowVariables(@NonNull Class<Solution_> solutionClass, Object ... entities) {
        Objects.requireNonNull(solutionClass);
        Objects.requireNonNull(entities);
        if (entities.length == 0) {
            throw new IllegalArgumentException("The entity array cannot be empty.");
        }
        ShadowVariableUpdateHelper.create().updateShadowVariables(solutionClass, entities);
    }

    public static <Solution_> void updateShadowVariables(@NonNull Solution_ solution) {
        Objects.requireNonNull(solution);
        ShadowVariableUpdateHelper.create().updateShadowVariables(solution);
    }

    default public @NonNull ScoreExplanation<Solution_, Score_> explain(@NonNull Solution_ solution) {
        return this.explain(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public @NonNull ScoreExplanation<Solution_, Score_> explain(@NonNull Solution_ var1, @NonNull SolutionUpdatePolicy var2);

    default public @NonNull ScoreAnalysis<Score_> analyze(@NonNull Solution_ solution) {
        return this.analyze(solution, ScoreAnalysisFetchPolicy.FETCH_ALL, SolutionUpdatePolicy.UPDATE_ALL);
    }

    default public @NonNull ScoreAnalysis<Score_> analyze(@NonNull Solution_ solution, @NonNull ScoreAnalysisFetchPolicy fetchPolicy) {
        return this.analyze(solution, fetchPolicy, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public @NonNull ScoreAnalysis<Score_> analyze(@NonNull Solution_ var1, @NonNull ScoreAnalysisFetchPolicy var2, @NonNull SolutionUpdatePolicy var3);

    public @NonNull PlanningSolutionDiff<Solution_> diff(@NonNull Solution_ var1, @NonNull Solution_ var2);

    default public <EntityOrElement_, Proposition_> @NonNull List<RecommendedAssignment<Proposition_, Score_>> recommendAssignment(@NonNull Solution_ solution, EntityOrElement_ evaluatedEntityOrElement, @NonNull Function<EntityOrElement_, @NonNull Proposition_> propositionFunction) {
        return this.recommendAssignment(solution, evaluatedEntityOrElement, propositionFunction, ScoreAnalysisFetchPolicy.FETCH_ALL);
    }

    public <EntityOrElement_, Proposition_> @NonNull List<RecommendedAssignment<Proposition_, Score_>> recommendAssignment(@NonNull Solution_ var1, @NonNull EntityOrElement_ var2, @NonNull Function<EntityOrElement_, Proposition_> var3, @NonNull ScoreAnalysisFetchPolicy var4);

    @Deprecated(forRemoval=true, since="1.15.0")
    default public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ solution, EntityOrElement_ fittedEntityOrElement, Function<EntityOrElement_, Proposition_> propositionFunction) {
        return this.recommendFit(solution, fittedEntityOrElement, propositionFunction, ScoreAnalysisFetchPolicy.FETCH_ALL);
    }

    @Deprecated(forRemoval=true, since="1.15.0")
    public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ var1, EntityOrElement_ var2, Function<EntityOrElement_, Proposition_> var3, ScoreAnalysisFetchPolicy var4);
}

