/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.monitoring.statistic;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.event.SolverEventListener;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.event.DefaultBestSolutionChangedEvent;
import ai.timefold.solver.core.impl.solver.monitoring.ScoreLevels;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.SolverStatistic;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class BestScoreStatistic<Solution_>
implements SolverStatistic<Solution_> {
    private final Map<Tags, ScoreLevels> tagsToBestScoreMap = new ConcurrentHashMap<Tags, ScoreLevels>();
    private final Map<Solver<Solution_>, SolverEventListener<Solution_>> solverToEventListenerMap = new WeakHashMap<Solver<Solution_>, SolverEventListener<Solution_>>();

    @Override
    public void unregister(Solver<Solution_> solver) {
        SolverEventListener<Solution_> listener = this.solverToEventListenerMap.remove(solver);
        if (listener != null) {
            solver.removeEventListener(listener);
        }
        this.tagsToBestScoreMap.remove(BestScoreStatistic.extractTags(solver));
    }

    private static Tags extractTags(Solver<?> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        return defaultSolver.getSolverScope().getMonitoringTags();
    }

    @Override
    public void register(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        ScoreDefinition scoreDefinition = defaultSolver.getSolverScope().getScoreDefinition();
        Tags tags = BestScoreStatistic.extractTags(solver);
        SolverEventListener listener = event -> {
            DefaultBestSolutionChangedEvent castEvent = (DefaultBestSolutionChangedEvent)event;
            SolverMetricUtil.registerScore(SolverMetric.BEST_SCORE, tags, scoreDefinition, this.tagsToBestScoreMap, InnerScore.withUnassignedCount(event.getNewBestScore(), castEvent.getUnassignedCount()));
        };
        this.solverToEventListenerMap.put(defaultSolver, listener);
        defaultSolver.addEventListener(listener);
    }
}

