/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.TupleSource;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.bavet.uni.ForEachExcludingUnassignedUniNode;
import ai.timefold.solver.core.impl.bavet.uni.ForEachIncludingUnassignedUniNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class BavetForEachUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A>
implements TupleSource {
    private final Class<A> forEachClass;
    private final Predicate<A> filter;

    public BavetForEachUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, Class<A> forEachClass, Predicate<A> filter, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
        this.forEachClass = forEachClass;
        if (forEachClass == null) {
            throw new IllegalArgumentException("The forEachClass (null) cannot be null.");
        }
        this.filter = filter;
    }

    @Override
    public boolean guaranteesDistinct() {
        return true;
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        TupleLifecycle tupleLifecycle = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractForEachUniNode node = this.filter == null ? new ForEachIncludingUnassignedUniNode<A>(this.forEachClass, tupleLifecycle, outputStoreSize) : new ForEachExcludingUnassignedUniNode<A>(this.forEachClass, this.filter, tupleLifecycle, outputStoreSize);
        buildHelper.addNode(node, this, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BavetForEachUniConstraintStream that = (BavetForEachUniConstraintStream)other;
        return Objects.equals(this.forEachClass, that.forEachClass) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.forEachClass, this.filter);
    }

    public String toString() {
        if (this.filter != null) {
            return "ForEach(" + this.forEachClass.getSimpleName() + ") with filter and " + this.childStreamList.size() + " children";
        }
        return "ForEach(" + this.forEachClass.getSimpleName() + ") with " + this.childStreamList.size() + " children";
    }
}

