/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.lookup.LookUpManager;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerSupport;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.SolutionTracker;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.move.MoveRepository;
import ai.timefold.solver.core.impl.move.MoveStreamsBasedMoveRepository;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorCache;
import ai.timefold.solver.core.impl.solver.exception.CloningCorruptionException;
import ai.timefold.solver.core.impl.solver.exception.ScoreCorruptionException;
import ai.timefold.solver.core.impl.solver.exception.UndoScoreCorruptionException;
import ai.timefold.solver.core.impl.solver.exception.VariableCorruptionException;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<Solution_, Score_ extends Score<Score_>, Factory_ extends AbstractScoreDirectorFactory<Solution_, Score_, Factory_>>
implements InnerScoreDirector<Solution_, Score_>,
Cloneable {
    private static final int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean lookUpEnabled;
    private final LookUpManager lookUpManager;
    protected final ConstraintMatchPolicy constraintMatchPolicy;
    private final boolean expectShadowVariablesInCorrectState;
    protected final Factory_ scoreDirectorFactory;
    private final VariableDescriptorCache<Solution_> variableDescriptorCache;
    protected final VariableListenerSupport<Solution_> variableListenerSupport;
    private long workingEntityListRevision = 0L;
    private int workingGenuineEntityCount = 0;
    private boolean allChangesWillBeUndoneBeforeStepEnds = false;
    private long calculationCount = 0L;
    protected Solution_ workingSolution;
    private int workingInitScore = 0;
    private final @Nullable SolutionTracker<Solution_> solutionTracker;
    private final MoveDirector<Solution_, Score_> moveDirector = new MoveDirector(this);
    private @Nullable MoveRepository<Solution_> moveRepository;
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;

    protected AbstractScoreDirector(Factory_ scoreDirectorFactory, boolean lookUpEnabled, ConstraintMatchPolicy constraintMatchPolicy, boolean expectShadowVariablesInCorrectState) {
        SolutionDescriptor solutionDescriptor = ((AbstractScoreDirectorFactory)scoreDirectorFactory).getSolutionDescriptor();
        this.lookUpEnabled = lookUpEnabled;
        this.lookUpManager = lookUpEnabled ? new LookUpManager(solutionDescriptor.getLookUpStrategyResolver()) : null;
        this.constraintMatchPolicy = constraintMatchPolicy;
        this.expectShadowVariablesInCorrectState = expectShadowVariablesInCorrectState;
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.variableDescriptorCache = new VariableDescriptorCache(solutionDescriptor);
        this.variableListenerSupport = VariableListenerSupport.create(this);
        this.variableListenerSupport.linkVariableListeners();
        this.solutionTracker = ((AbstractScoreDirectorFactory)scoreDirectorFactory).isTrackingWorkingSolution() ? new SolutionTracker<Solution_>(this.getSolutionDescriptor(), this.getSupplyManager()) : null;
        ListVariableDescriptor listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        this.listVariableStateSupply = listVariableDescriptor == null ? null : (ListVariableStateSupply)this.getSupplyManager().demand(listVariableDescriptor.getStateDemand());
    }

    @Override
    public final ConstraintMatchPolicy getConstraintMatchPolicy() {
        return this.constraintMatchPolicy;
    }

    public Factory_ getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition<Score_> getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public VariableDescriptorCache<Solution_> getVariableDescriptorCache() {
        return this.variableDescriptorCache;
    }

    @Override
    public ListVariableStateSupply<Solution_> getListVariableStateSupply(ListVariableDescriptor<Solution_> variableDescriptor) {
        ListVariableDescriptor<Solution_> originalListVariableDescriptor = this.getSolutionDescriptor().getListVariableDescriptor();
        if (variableDescriptor != originalListVariableDescriptor) {
            throw new IllegalStateException("The variableDescriptor (%s) is not the same as the solution's variableDescriptor (%s).".formatted(variableDescriptor, originalListVariableDescriptor));
        }
        return Objects.requireNonNull(this.listVariableStateSupply);
    }

    @Override
    public boolean expectShadowVariablesInCorrectState() {
        return this.expectShadowVariablesInCorrectState;
    }

    @Override
    public @NonNull Solution_ getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public int getWorkingInitScore() {
        return this.workingInitScore;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    @Override
    public int getWorkingGenuineEntityCount() {
        return this.workingGenuineEntityCount;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculationCount() {
        return this.calculationCount;
    }

    @Override
    public void resetCalculationCount() {
        this.calculationCount = 0L;
    }

    @Override
    public void incrementCalculationCount() {
        ++this.calculationCount;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public MoveDirector<Solution_, Score_> getMoveDirector() {
        return this.moveDirector;
    }

    protected void setWorkingSolution(Solution_ workingSolution, Consumer<Object> entityAndFactVisitor) {
        this.workingSolution = Objects.requireNonNull(workingSolution);
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
            Consumer<Object> workingObjectLookupVisitor = this.lookUpManager::addWorkingObject;
            Consumer<Object> consumer = entityAndFactVisitor = entityAndFactVisitor == null ? workingObjectLookupVisitor : entityAndFactVisitor.andThen(workingObjectLookupVisitor);
        }
        if (entityAndFactVisitor != null) {
            solutionDescriptor.visitAllProblemFacts(workingSolution, entityAndFactVisitor);
        }
        Consumer<Object> entityValidator = entity -> ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).validateEntity(this, entity);
        entityAndFactVisitor = entityAndFactVisitor == null ? entityValidator : entityAndFactVisitor.andThen(entityValidator);
        SolutionDescriptor.SolutionInitializationStatistics initializationStatistics = solutionDescriptor.computeInitializationStatistics(workingSolution, entityAndFactVisitor);
        this.setWorkingEntityListDirty();
        this.workingInitScore = -(initializationStatistics.unassignedValueCount() + initializationStatistics.uninitializedVariableCount());
        this.assertInitScoreZeroOrLess();
        this.workingGenuineEntityCount = initializationStatistics.genuineEntityCount();
        this.variableListenerSupport.resetWorkingSolution();
        if (this.moveRepository != null) {
            this.moveRepository.initialize(workingSolution, this.getSupplyManager());
        }
    }

    @Override
    public void setMoveRepository(@Nullable MoveRepository<Solution_> moveRepository) {
        this.moveRepository = moveRepository;
        if (moveRepository != null) {
            moveRepository.initialize(this.workingSolution, this.getSupplyManager());
        }
    }

    private void assertInitScoreZeroOrLess() {
        if (this.workingInitScore > 0) {
            throw new IllegalStateException("workingInitScore > 0 (%d).\nMaybe a custom move is removing more entities than were ever added?\n".formatted(this.workingInitScore));
        }
    }

    @Override
    public void executeMove(Move<Solution_> move) {
        this.moveDirector.execute(move);
    }

    @Override
    public InnerScore<Score_> executeTemporaryMove(Move<Solution_> move, boolean assertMoveScoreFromScratch) {
        this.allChangesWillBeUndoneBeforeStepEnds = true;
        if (this.solutionTracker != null) {
            this.solutionTracker.setBeforeMoveSolution(this.workingSolution);
        }
        InnerScore moveScore = assertMoveScoreFromScratch ? (InnerScore)this.moveDirector.executeTemporary(move, (score, undoMove) -> {
            if (this.solutionTracker != null) {
                this.solutionTracker.setAfterMoveSolution(this.workingSolution);
            }
            this.assertWorkingScoreFromScratch((InnerScore<Score_>)score, move);
            return score;
        }) : this.moveDirector.executeTemporary(move);
        this.allChangesWillBeUndoneBeforeStepEnds = false;
        return moveScore;
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    @Override
    public boolean isWorkingSolutionInitialized() {
        return this.workingInitScore == 0;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Object originalScore = solutionDescriptor.getScore(originalSolution);
        Solution_ cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        Object cloneScore = solutionDescriptor.getScore(cloneSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!Objects.equals(originalScore, cloneScore)) {
                throw new CloningCorruptionException("Cloning corruption: the original's score (%s) is different from the clone's score (%s).\nCheck the %s.".formatted(originalScore, cloneScore, SolutionCloner.class.getSimpleName()));
            }
            IdentityHashMap originalEntityMap = new IdentityHashMap();
            solutionDescriptor.visitAllEntities(originalSolution, originalEntity -> originalEntityMap.put(originalEntity, null));
            solutionDescriptor.visitAllEntities(cloneSolution, cloneEntity -> {
                if (originalEntityMap.containsKey(cloneEntity)) {
                    throw new CloningCorruptionException("Cloning corruption: the same entity (%s) is present in both the original and the clone.\nSo when a planning variable in the original solution changes, the cloned solution will change too.\nCheck the %s.".formatted(cloneEntity, SolutionCloner.class.getSimpleName()));
                }
            });
        }
        return cloneSolution;
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    protected void clearVariableListenerEvents() {
        this.variableListenerSupport.clearAllVariableListenerEvents();
    }

    @Override
    public void forceTriggerVariableListeners() {
        this.variableListenerSupport.forceTriggerAllVariableListeners(this.getWorkingSolution());
    }

    protected void setCalculatedScore(Score_ score) {
        this.getSolutionDescriptor().setScore(this.workingSolution, score);
        ++this.calculationCount;
    }

    @Deprecated(forRemoval=true, since="1.14.0")
    public AbstractScoreDirector<Solution_, Score_, Factory_> clone() {
        throw new UnsupportedOperationException("Cloning score directors is not supported.");
    }

    @Override
    public InnerScoreDirector<Solution_, Score_> createChildThreadScoreDirector(ChildThreadType childThreadType) {
        if (childThreadType == ChildThreadType.PART_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = ((AbstractScoreDirectorBuilder)((AbstractScoreDirectorBuilder)this.scoreDirectorFactory.createScoreDirectorBuilder().withLookUpEnabled(this.lookUpEnabled)).withConstraintMatchPolicy(this.constraintMatchPolicy)).buildDerived();
            childThreadScoreDirector.calculationCount = this.calculationCount;
            return childThreadScoreDirector;
        }
        if (childThreadType == ChildThreadType.MOVE_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = ((AbstractScoreDirectorBuilder)((AbstractScoreDirectorBuilder)this.scoreDirectorFactory.createScoreDirectorBuilder().withLookUpEnabled(true)).withConstraintMatchPolicy(this.constraintMatchPolicy)).buildDerived();
            childThreadScoreDirector.setWorkingSolution(this.cloneWorkingSolution());
            return childThreadScoreDirector;
        }
        throw new IllegalStateException("The childThreadType (" + String.valueOf((Object)childThreadType) + ") is not implemented.");
    }

    @Override
    public void close() {
        this.workingSolution = null;
        this.workingInitScore = 0;
        if (this.lookUpEnabled) {
            this.lookUpManager.reset();
        }
        if (this.listVariableStateSupply != null) {
            this.getSupplyManager().cancel(((ListVariableDescriptor)this.listVariableStateSupply.getSourceVariableDescriptor()).getStateDemand());
        }
        this.variableListenerSupport.close();
    }

    @Override
    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore -= entityDescriptor.countUninitializedVariables(entity);
        if (entityDescriptor.isGenuine()) {
            ++this.workingGenuineEntityCount;
        }
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            MoveRepository<Solution_> moveRepository = this.moveRepository;
            if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
                MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
                moveStreamsBasedMoveRepository.insert(entity);
            }
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            ++this.workingInitScore;
        }
        this.assertInitScoreZeroOrLess();
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        MoveRepository<Solution_> moveRepository;
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            --this.workingInitScore;
        }
        if ((moveRepository = this.moveRepository) instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.update(entity);
        }
        this.variableListenerSupport.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        MoveRepository<Solution_> moveRepository;
        if (!variableDescriptor.allowsUnassignedValues()) {
            ++this.workingInitScore;
            this.assertInitScoreZeroOrLess();
        }
        if ((moveRepository = this.moveRepository) instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.update(element);
        }
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        if (!variableDescriptor.allowsUnassignedValues()) {
            --this.workingInitScore;
        }
        this.variableListenerSupport.afterElementUnassigned(variableDescriptor, element);
        MoveRepository<Solution_> moveRepository = this.moveRepository;
        if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.update(element);
        }
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        if (variableDescriptor.isElementPinned(this.getWorkingSolution(), entity, fromIndex)) {
            throw new IllegalStateException("Attempting to change list variable (%s) on an entity (%s) in range [%d, %d), which is partially or entirely pinned.\nThis is most likely a bug in a move.\nMaybe you are using an improperly implemented custom move?".formatted(variableDescriptor, entity, fromIndex, toIndex));
        }
        this.variableListenerSupport.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.variableListenerSupport.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
        MoveRepository<Solution_> moveRepository = this.moveRepository;
        if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.update(entity);
        }
    }

    @Override
    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore += entityDescriptor.countUninitializedVariables(entity);
        this.assertInitScoreZeroOrLess();
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entityDescriptor.isGenuine()) {
            --this.workingGenuineEntityCount;
        }
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(entity);
        }
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            MoveRepository<Solution_> moveRepository = this.moveRepository;
            if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
                MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
                moveStreamsBasedMoveRepository.retract(entity);
            }
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
        MoveRepository<Solution_> moveRepository = this.moveRepository;
        if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.insert(problemFact);
        }
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        if (this.isConstraintConfiguration(problemFactOrEntity)) {
            this.setWorkingSolution(this.workingSolution);
        } else {
            this.variableListenerSupport.resetWorkingSolution();
            MoveRepository<Solution_> moveRepository = this.moveRepository;
            if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
                MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
                moveStreamsBasedMoveRepository.update(problemFactOrEntity);
            }
        }
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        if (this.isConstraintConfiguration(problemFact)) {
            throw new IllegalStateException("Attempted to remove constraint configuration (%s) from solution (%s).\nMaybe use before/afterProblemPropertyChanged(...) instead.".formatted(problemFact, this.workingSolution));
        }
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
        MoveRepository<Solution_> moveRepository = this.moveRepository;
        if (moveRepository instanceof MoveStreamsBasedMoveRepository) {
            MoveStreamsBasedMoveRepository moveStreamsBasedMoveRepository = (MoveStreamsBasedMoveRepository)moveRepository;
            moveStreamsBasedMoveRepository.retract(problemFact);
        }
    }

    @Override
    public <E> @Nullable E lookUpWorkingObject(@Nullable E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (%s) is disabled in the constructor, this method should not be called.".formatted(this.lookUpEnabled));
        }
        return this.lookUpManager.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> @Nullable E lookUpWorkingObjectOrReturnNull(@Nullable E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (%s) is disabled in the constructor, this method should not be called.".formatted(this.lookUpEnabled));
        }
        return this.lookUpManager.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void assertExpectedWorkingScore(InnerScore<Score_> expectedWorkingScore, Object completedAction) {
        InnerScore workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new ScoreCorruptionException("Score corruption (%s): the expectedWorkingScore (%s) is not the workingScore (%s) after completedAction (%s).".formatted(expectedWorkingScore.raw().subtract(workingScore.raw()).toShortString(), expectedWorkingScore, workingScore, completedAction));
        }
    }

    @Override
    public void assertShadowVariablesAreNotStale(InnerScore<Score_> expectedWorkingScore, Object completedAction) {
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        if (violationMessage != null) {
            throw new VariableCorruptionException("%s corruption after completedAction (%s):\n%s".formatted(VariableListener.class.getSimpleName(), completedAction, violationMessage));
        }
        InnerScore workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            this.assertWorkingScoreFromScratch(workingScore, "assertShadowVariablesAreNotStale(" + String.valueOf(expectedWorkingScore) + ", " + String.valueOf(completedAction) + ")");
            throw new VariableCorruptionException("Impossible %s corruption (%s): the expectedWorkingScore (%s) is not the workingScore (%s) after all %s were triggered without changes to the genuine variables after completedAction (%s).\nAll the shadow variable values are still the same, so this is impossible.\nMaybe run with %s if you haven't already, to fail earlier.".formatted(new Object[]{VariableListener.class.getSimpleName(), expectedWorkingScore.raw().subtract(workingScore.raw()).toShortString(), expectedWorkingScore, workingScore, VariableListener.class.getSimpleName(), completedAction, EnvironmentMode.TRACKED_FULL_ASSERT}));
        }
    }

    protected String buildShadowVariableAnalysis(boolean predicted) {
        String workingLabel;
        String violationMessage = this.variableListenerSupport.createShadowVariablesViolationMessage();
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (violationMessage == null) {
            return "Shadow variable corruption in the %s scoreDirector:\n  None".formatted(workingLabel);
        }
        return "Shadow variable corruption in the %s scoreDirector:\n%s\n  Maybe there is a bug in the %s of those shadow variable(s).".formatted(workingLabel, violationMessage, VariableListener.class.getSimpleName());
    }

    @Override
    public void assertWorkingScoreFromScratch(InnerScore<Score_> workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, false);
    }

    @Override
    public void assertPredictedScoreFromScratch(InnerScore<Score_> workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, true);
    }

    private void assertScoreFromScratch(InnerScore<Score_> innerScore, Object completedAction, boolean predicted) {
        ScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        try (AbstractScoreDirector uncorruptedScoreDirector = ((AbstractScoreDirectorBuilder)assertionScoreDirectorFactory.createScoreDirectorBuilder().withConstraintMatchPolicy(ConstraintMatchPolicy.ENABLED)).buildDerived();){
            uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
            InnerScore uncorruptedInnerScore = uncorruptedScoreDirector.calculateScore();
            if (!innerScore.equals(uncorruptedInnerScore)) {
                String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector, predicted);
                String shadowVariableAnalysis = this.buildShadowVariableAnalysis(predicted);
                throw new ScoreCorruptionException("Score corruption (%s): the %s (%s) is not the uncorruptedScore (%s) after completedAction (%s):\n%s\n%s".formatted(innerScore.raw().subtract(uncorruptedInnerScore.raw()).toShortString(), predicted ? "predictedScore" : "workingScore", innerScore, uncorruptedInnerScore, completedAction, scoreCorruptionAnalysis, shadowVariableAnalysis));
            }
        }
    }

    @Override
    public void assertExpectedUndoMoveScore(Move<Solution_> move, InnerScore<Score_> beforeMoveInnerScore, SolverLifecyclePoint executionPoint) {
        boolean trackingWorkingSolution;
        InnerScore undoInnerScore = this.calculateScore();
        if (Objects.equals(undoInnerScore, beforeMoveInnerScore)) {
            return;
        }
        this.logger.trace("        Corruption detected. Diagnosing...");
        boolean bl = trackingWorkingSolution = this.solutionTracker != null;
        if (trackingWorkingSolution) {
            this.solutionTracker.setAfterUndoSolution(this.workingSolution);
        }
        String undoMoveToString = "Undo(%s)".formatted(move);
        this.assertWorkingScoreFromScratch(undoInnerScore, undoMoveToString);
        this.assertShadowVariablesAreNotStale(undoInnerScore, undoMoveToString);
        String corruptionDiagnosis = "";
        if (trackingWorkingSolution) {
            this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
            this.solutionTracker.setUndoFromScratchSolution(this.workingSolution);
            this.solutionTracker.restoreBeforeSolution();
            this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
            this.solutionTracker.setBeforeFromScratchSolution(this.workingSolution);
            corruptionDiagnosis = this.solutionTracker.buildScoreCorruptionMessage();
        }
        String scoreDifference = undoInnerScore.raw().subtract(beforeMoveInnerScore.raw()).toShortString();
        String corruptionMessage = "UndoMove corruption (%s):\n   the beforeMoveScore (%s) is not the undoScore (%s),\n   which is the uncorruptedScore (%s) of the workingSolution.\n\nCorruption diagnosis:\n%s\n\n1) Enable EnvironmentMode %s (if you haven't already)\n   to fail-faster in case of a score corruption or variable listener corruption.\n   Let the solver run until it reaches the same point in its lifecycle (%s),\n   even though it may take a very long time.\n   If the solver throws an exception before reaching that point,\n   there may be yet another problem that needs to be fixed.\n\n2) If you use custom moves, check the Move.createUndoMove(...) method of the custom move class (%s).\n   The move (%s) might have a corrupted undoMove (%s).\n\n3) If you use custom %ss,\n   check them for shadow variables that are used by score constraints\n   that could cause the scoreDifference (%s).".formatted(new Object[]{scoreDifference, beforeMoveInnerScore, undoInnerScore, undoInnerScore, corruptionDiagnosis, EnvironmentMode.TRACKED_FULL_ASSERT, executionPoint, move.getClass().getSimpleName(), move, undoMoveToString, VariableListener.class.getSimpleName(), scoreDifference});
        if (trackingWorkingSolution) {
            throw new UndoScoreCorruptionException(corruptionMessage, this.solutionTracker.getBeforeMoveSolution(), this.solutionTracker.getAfterMoveSolution(), this.solutionTracker.getAfterUndoSolution());
        }
        throw new ScoreCorruptionException(corruptionMessage);
    }

    public SolutionTracker.SolutionCorruptionResult getSolutionCorruptionAfterUndo(Move<Solution_> move, InnerScore<Score_> undoInnerScore) {
        boolean trackingWorkingSolution;
        boolean bl = trackingWorkingSolution = this.solutionTracker != null;
        if (trackingWorkingSolution) {
            this.solutionTracker.setAfterUndoSolution(this.workingSolution);
        }
        String undoMoveToString = "Undo(%s)".formatted(move);
        this.assertWorkingScoreFromScratch(undoInnerScore, undoMoveToString);
        this.assertShadowVariablesAreNotStale(undoInnerScore, undoMoveToString);
        if (trackingWorkingSolution) {
            this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
            this.solutionTracker.setUndoFromScratchSolution(this.workingSolution);
            this.solutionTracker.restoreBeforeSolution();
            this.variableListenerSupport.forceTriggerAllVariableListeners(this.workingSolution);
            this.solutionTracker.setBeforeFromScratchSolution(this.workingSolution);
            return this.solutionTracker.buildSolutionCorruptionResult();
        }
        return SolutionTracker.SolutionCorruptionResult.untracked();
    }

    protected String buildScoreCorruptionAnalysis(InnerScoreDirector<Solution_, Score_> uncorruptedScoreDirector, boolean predicted) {
        if (!this.getConstraintMatchPolicy().isEnabled() || !uncorruptedScoreDirector.getConstraintMatchPolicy().isEnabled()) {
            return "Score corruption analysis could not be generated because either corrupted constraintMatchPolicy (%s) or uncorrupted constraintMatchPolicy (%s) is %s.\n  Check your score constraints manually.".formatted(new Object[]{this.constraintMatchPolicy, uncorruptedScoreDirector.getConstraintMatchPolicy(), ConstraintMatchPolicy.DISABLED});
        }
        ScoreAnalysis corruptedAnalysis = this.buildScoreAnalysis(ScoreAnalysisFetchPolicy.FETCH_ALL);
        ScoreAnalysis<Score_> uncorruptedAnalysis = uncorruptedScoreDirector.buildScoreAnalysis(ScoreAnalysisFetchPolicy.FETCH_ALL);
        LinkedHashSet<MatchAnalysis<Score_>> excessSet = new LinkedHashSet<MatchAnalysis<Score_>>();
        LinkedHashSet<MatchAnalysis<Score_>> missingSet = new LinkedHashSet<MatchAnalysis<Score_>>();
        uncorruptedAnalysis.constraintMap().forEach((constraintRef, uncorruptedConstraintAnalysis) -> {
            List<MatchAnalysis<Score_>> uncorruptedConstraintMatches = AbstractScoreDirector.emptyMatchAnalysisIfNull(uncorruptedConstraintAnalysis);
            List corruptedConstraintMatches = AbstractScoreDirector.emptyMatchAnalysisIfNull(corruptedAnalysis.constraintMap().get(constraintRef));
            if (corruptedConstraintMatches.isEmpty()) {
                missingSet.addAll(uncorruptedConstraintMatches);
            } else {
                this.updateExcessAndMissingConstraintMatches(uncorruptedConstraintMatches, corruptedConstraintMatches, excessSet, missingSet);
            }
        });
        corruptedAnalysis.constraintMap().forEach((constraintRef, corruptedConstraintAnalysis) -> {
            List<MatchAnalysis<Score_>> corruptedConstraintMatches = AbstractScoreDirector.emptyMatchAnalysisIfNull(corruptedConstraintAnalysis);
            List uncorruptedConstraintMatches = AbstractScoreDirector.emptyMatchAnalysisIfNull(uncorruptedAnalysis.constraintMap().get(constraintRef));
            if (uncorruptedConstraintMatches.isEmpty()) {
                excessSet.addAll(corruptedConstraintMatches);
            } else {
                this.updateExcessAndMissingConstraintMatches(uncorruptedConstraintMatches, corruptedConstraintMatches, excessSet, missingSet);
            }
        });
        StringBuilder analysis = new StringBuilder();
        analysis.append("Score corruption analysis:\n");
        String workingLabel = predicted ? "working" : "corrupted";
        this.appendAnalysis(analysis, workingLabel, "should not be there", excessSet);
        this.appendAnalysis(analysis, workingLabel, "are missing", missingSet);
        if (!missingSet.isEmpty() || !excessSet.isEmpty()) {
            analysis.append("  Maybe there is a bug in the score constraints of those ConstraintMatch(s).\n  Maybe a score constraint doesn't select all the entities it depends on,\n    but discovers some transitively through a reference from the selected entity.\n    This corrupts incremental score calculation,\n    because the constraint is not re-evaluated if the transitively discovered entity changes.\n".stripTrailing());
        } else if (predicted) {
            analysis.append("  If multi-threaded solving is active:\n    - the working scoreDirector is probably not the corrupted scoreDirector.\n    - maybe the rebase() method of the move is bugged.\n    - maybe a VariableListener affected the moveThread's workingSolution after doing and undoing a move,\n      but this didn't happen here on the solverThread, so we can't detect it.\n".stripTrailing());
        } else {
            analysis.append("  Impossible state. Maybe this is a bug in the scoreDirector (%s).".formatted(this.getClass()));
        }
        return analysis.toString();
    }

    private static <Score_ extends Score<Score_>> List<MatchAnalysis<Score_>> emptyMatchAnalysisIfNull(ConstraintAnalysis<Score_> constraintAnalysis) {
        if (constraintAnalysis == null) {
            return Collections.emptyList();
        }
        return Objects.requireNonNullElse(constraintAnalysis.matches(), Collections.emptyList());
    }

    private void appendAnalysis(StringBuilder analysis, String workingLabel, String suffix, Set<MatchAnalysis<Score_>> matches) {
        if (matches.isEmpty()) {
            analysis.append("  The %s scoreDirector has no ConstraintMatch(es) which %s.\n".formatted(workingLabel, suffix));
        } else {
            analysis.append("  The %s scoreDirector has %s ConstraintMatch(es) which %s:\n".formatted(workingLabel, matches.size(), suffix));
            matches.stream().sorted().limit(8L).forEach(match -> analysis.append("    %s/%s=%s\n".formatted(match.constraintRef().constraintId(), match.justification(), match.score())));
            if (matches.size() >= 8) {
                analysis.append("    ... %s more\n".formatted(matches.size() - 8));
            }
        }
    }

    private void updateExcessAndMissingConstraintMatches(List<MatchAnalysis<Score_>> uncorruptedList, List<MatchAnalysis<Score_>> corruptedList, Set<MatchAnalysis<Score_>> excessSet, Set<MatchAnalysis<Score_>> missingSet) {
        this.iterateAndAddIfFound(corruptedList, uncorruptedList, excessSet);
        this.iterateAndAddIfFound(uncorruptedList, corruptedList, missingSet);
    }

    private void iterateAndAddIfFound(List<MatchAnalysis<Score_>> referenceList, List<MatchAnalysis<Score_>> lookupList, Set<MatchAnalysis<Score_>> targetSet) {
        if (referenceList.isEmpty()) {
            return;
        }
        LinkedHashSet<MatchAnalysis<Score_>> lookupSet = new LinkedHashSet<MatchAnalysis<Score_>>(lookupList);
        for (MatchAnalysis<Score_> reference : referenceList) {
            if (lookupSet.contains(reference)) continue;
            targetSet.add(reference);
        }
    }

    protected boolean isConstraintConfiguration(Object problemFactOrEntity) {
        SolutionDescriptor solutionDescriptor = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
        ConstraintWeightSupplier constraintWeightSupplier = solutionDescriptor.getConstraintWeightSupplier();
        if (constraintWeightSupplier == null) {
            return false;
        }
        return constraintWeightSupplier.getProblemFactClass().isInstance(problemFactOrEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculationCount + ")";
    }

    @NullMarked
    public static abstract class AbstractScoreDirectorBuilder<Solution_, Score_ extends Score<Score_>, Factory_ extends AbstractScoreDirectorFactory<Solution_, Score_, Factory_>, Builder_ extends AbstractScoreDirectorBuilder<Solution_, Score_, Factory_, Builder_>> {
        protected final Factory_ scoreDirectorFactory;
        protected ConstraintMatchPolicy constraintMatchPolicy = ConstraintMatchPolicy.DISABLED;
        protected boolean lookUpEnabled = false;
        protected boolean expectShadowVariablesInCorrectState = true;

        protected AbstractScoreDirectorBuilder(Factory_ scoreDirectorFactory) {
            this.scoreDirectorFactory = (AbstractScoreDirectorFactory)Objects.requireNonNull(scoreDirectorFactory);
        }

        public Builder_ withConstraintMatchPolicy(ConstraintMatchPolicy constraintMatchPolicy) {
            this.constraintMatchPolicy = constraintMatchPolicy;
            return (Builder_)this;
        }

        public Builder_ withLookUpEnabled(boolean lookUpEnabled) {
            this.lookUpEnabled = lookUpEnabled;
            return (Builder_)this;
        }

        public Builder_ withExpectShadowVariablesInCorrectState(boolean expectShadowVariablesInCorrectState) {
            this.expectShadowVariablesInCorrectState = expectShadowVariablesInCorrectState;
            return (Builder_)this;
        }

        public abstract AbstractScoreDirector<Solution_, Score_, Factory_> build();

        public AbstractScoreDirector<Solution_, Score_, Factory_> buildDerived() {
            return this.build();
        }
    }
}

