/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public final class ProbabilityValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntityIndependentValueSelector<Solution_>,
SelectionCacheLifecycleListener<Solution_> {
    private final EntityIndependentValueSelector<Solution_> childValueSelector;
    private final SelectionCacheType cacheType;
    private final SelectionProbabilityWeightFactory<Solution_, Object> probabilityWeightFactory;
    private NavigableMap<Double, Object> cachedEntityMap = null;
    private double probabilityWeightTotal = -1.0;

    public ProbabilityValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector, SelectionCacheType cacheType, SelectionProbabilityWeightFactory<Solution_, Object> probabilityWeightFactory) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        this.probabilityWeightFactory = probabilityWeightFactory;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(childValueSelector) + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") does not support the cacheType (" + String.valueOf((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        this.cachedEntityMap = new TreeMap<Double, Object>();
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        double probabilityWeightOffset = 0.0;
        for (Object t : this.childValueSelector) {
            double probabilityWeight = this.probabilityWeightFactory.createProbabilityWeight(scoreDirector, t);
            this.cachedEntityMap.put(probabilityWeightOffset, t);
            probabilityWeightOffset += probabilityWeight;
        }
        this.probabilityWeightTotal = probabilityWeightOffset;
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.probabilityWeightTotal = -1.0;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.cachedEntityMap.size();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Object next() {
                double randomOffset = RandomUtils.nextDouble(ProbabilityValueSelector.this.workingRandom, ProbabilityValueSelector.this.probabilityWeightTotal);
                return ProbabilityValueSelector.this.cachedEntityMap.floorEntry(randomOffset).getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The optional operation remove() is not supported.");
            }
        };
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProbabilityValueSelector that = (ProbabilityValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector) && this.cacheType == that.cacheType && Objects.equals(this.probabilityWeightFactory, that.probabilityWeightFactory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.childValueSelector, this.cacheType, this.probabilityWeightFactory});
    }

    public String toString() {
        return "Probability(" + String.valueOf(this.childValueSelector) + ")";
    }
}

