/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SwapMove<Solution_>
extends AbstractMove<Solution_> {
    protected final List<GenuineVariableDescriptor<Solution_>> variableDescriptorList;
    protected final Object leftEntity;
    protected final Object rightEntity;

    public SwapMove(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList, Object leftEntity, Object rightEntity) {
        this.variableDescriptorList = variableDescriptorList;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        boolean movable = false;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            Solution_ workingSolution;
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftEntity);
            if (Objects.equals(leftValue, rightValue = variableDescriptor.getValue(this.rightEntity))) continue;
            movable = true;
            if (variableDescriptor.isValueRangeEntityIndependent()) continue;
            ValueRangeDescriptor<Solution_> valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            ValueRange rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution = scoreDirector.getWorkingSolution(), this.rightEntity);
            if (!rightValueRange.contains(leftValue)) {
                return false;
            }
            ValueRange leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (leftValueRange.contains(rightValue)) continue;
            return false;
        }
        return movable;
    }

    @Override
    public SwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SwapMove<Solution_>(this.variableDescriptorList, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.rightEntity));
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(this.rightEntity))) continue;
            castScoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
            castScoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        StringBuilder moveTypeDescription = new StringBuilder(20 * (this.variableDescriptorList.size() + 1));
        moveTypeDescription.append(this.getClass().getSimpleName()).append("(");
        String delimiter = "";
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            moveTypeDescription.append(delimiter).append(variableDescriptor.getSimpleEntityAndVariableName());
            delimiter = ", ";
        }
        moveTypeDescription.append(")");
        return moveTypeDescription.toString();
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList values = new ArrayList(this.variableDescriptorList.size() * 2);
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            values.add(variableDescriptor.getValue(this.leftEntity));
            values.add(variableDescriptor.getValue(this.rightEntity));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwapMove swapMove = (SwapMove)o;
        return Objects.equals(this.variableDescriptorList, swapMove.variableDescriptorList) && Objects.equals(this.leftEntity, swapMove.leftEntity) && Objects.equals(this.rightEntity, swapMove.rightEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptorList, this.leftEntity, this.rightEntity);
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.variableDescriptorList.size() * 16);
        s.append(this.leftEntity).append(" {");
        this.appendVariablesToString(s, this.leftEntity);
        s.append("} <-> ");
        s.append(this.rightEntity).append(" {");
        this.appendVariablesToString(s, this.rightEntity);
        s.append("}");
        return s.toString();
    }

    protected void appendVariablesToString(StringBuilder s, Object entity) {
        boolean first = true;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            Object value;
            if (!first) {
                s.append(", ");
            }
            s.append((value = variableDescriptor.getValue(entity)) == null ? null : value.toString());
            first = false;
        }
    }
}

