/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ProbabilityMoveSelector<Solution_>
extends AbstractMoveSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_> {
    protected final MoveSelector<Solution_> childMoveSelector;
    protected final SelectionCacheType cacheType;
    protected final SelectionProbabilityWeightFactory<Solution_, Move<Solution_>> probabilityWeightFactory;
    protected NavigableMap<Double, Move<Solution_>> cachedMoveMap = null;
    protected double probabilityWeightTotal = -1.0;

    public ProbabilityMoveSelector(MoveSelector<Solution_> childMoveSelector, SelectionCacheType cacheType, SelectionProbabilityWeightFactory<Solution_, ? extends Move<Solution_>> probabilityWeightFactory) {
        this.childMoveSelector = childMoveSelector;
        this.cacheType = cacheType;
        this.probabilityWeightFactory = probabilityWeightFactory;
        if (childMoveSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childMoveSelector (" + String.valueOf(childMoveSelector) + ") with neverEnding (" + childMoveSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") does not support the cacheType (" + String.valueOf((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveMap = new TreeMap<Double, Move<Solution_>>();
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        double probabilityWeightOffset = 0.0;
        for (Move move : this.childMoveSelector) {
            double probabilityWeight = this.probabilityWeightFactory.createProbabilityWeight(scoreDirector, move);
            this.cachedMoveMap.put(probabilityWeightOffset, move);
            probabilityWeightOffset += probabilityWeight;
        }
        this.probabilityWeightTotal = probabilityWeightOffset;
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.probabilityWeightTotal = -1.0;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        return this.cachedMoveMap.size();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new Iterator<Move<Solution_>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Move<Solution_> next() {
                double randomOffset = RandomUtils.nextDouble(ProbabilityMoveSelector.this.workingRandom, ProbabilityMoveSelector.this.probabilityWeightTotal);
                return ProbabilityMoveSelector.this.cachedMoveMap.floorEntry(randomOffset).getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The optional operation remove() is not supported.");
            }
        };
    }

    public String toString() {
        return "Probability(" + String.valueOf(this.childMoveSelector) + ")";
    }
}

