/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list.mimic;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.SubListMimicRecorder;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class MimicReplayingSubListSelector<Solution_>
extends AbstractSelector<Solution_>
implements SubListSelector<Solution_> {
    protected final SubListMimicRecorder<Solution_> subListMimicRecorder;
    protected boolean hasRecordingCreated;
    protected boolean hasRecording;
    protected boolean recordingCreated;
    protected SubList recording;
    protected boolean recordingAlreadyReturned;

    public MimicReplayingSubListSelector(SubListMimicRecorder<Solution_> subListMimicRecorder) {
        this.subListMimicRecorder = subListMimicRecorder;
        subListMimicRecorder.addMimicReplayingSubListSelector(this);
        if (!subListMimicRecorder.getVariableDescriptor().isValueRangeEntityIndependent()) {
            throw new IllegalArgumentException("The current implementation support only an entityIndependent variable (" + String.valueOf(subListMimicRecorder.getVariableDescriptor()) + ").");
        }
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.hasRecordingCreated = false;
        this.recordingCreated = false;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.hasRecordingCreated = false;
        this.hasRecording = false;
        this.recordingCreated = false;
        this.recording = null;
    }

    @Override
    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.subListMimicRecorder.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.subListMimicRecorder.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.subListMimicRecorder.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.subListMimicRecorder.getSize();
    }

    @Override
    public Iterator<Object> endingValueIterator() {
        return this.subListMimicRecorder.endingValueIterator();
    }

    @Override
    public long getValueCount() {
        return this.subListMimicRecorder.getValueCount();
    }

    @Override
    public Iterator<SubList> iterator() {
        return new ReplayingSubListIterator();
    }

    public void recordedHasNext(boolean hasNext) {
        this.hasRecordingCreated = true;
        this.hasRecording = hasNext;
        this.recordingCreated = false;
        this.recording = null;
        this.recordingAlreadyReturned = false;
    }

    public void recordedNext(SubList next) {
        this.hasRecordingCreated = true;
        this.hasRecording = true;
        this.recordingCreated = true;
        this.recording = next;
        this.recordingAlreadyReturned = false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MimicReplayingSubListSelector that = (MimicReplayingSubListSelector)other;
        return Objects.equals(this.subListMimicRecorder, that.subListMimicRecorder);
    }

    public int hashCode() {
        return Objects.hash(this.subListMimicRecorder);
    }

    public String toString() {
        return "Replaying(" + String.valueOf(this.subListMimicRecorder) + ")";
    }

    private class ReplayingSubListIterator
    extends SelectionIterator<SubList> {
        private ReplayingSubListIterator() {
            MimicReplayingSubListSelector.this.recordingAlreadyReturned = false;
        }

        @Override
        public boolean hasNext() {
            if (!MimicReplayingSubListSelector.this.hasRecordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingSubListSelector (" + String.valueOf(MimicReplayingSubListSelector.this.subListMimicRecorder) + ")'s hasNext() has not been called yet. ");
            }
            return MimicReplayingSubListSelector.this.hasRecording && !MimicReplayingSubListSelector.this.recordingAlreadyReturned;
        }

        @Override
        public SubList next() {
            if (!MimicReplayingSubListSelector.this.recordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingSubListSelector (" + String.valueOf(MimicReplayingSubListSelector.this.subListMimicRecorder) + ")'s next() has not been called yet. ");
            }
            if (MimicReplayingSubListSelector.this.recordingAlreadyReturned) {
                throw new NoSuchElementException("The recordingAlreadyReturned (" + MimicReplayingSubListSelector.this.recordingAlreadyReturned + ") is impossible. Check if hasNext() returns true before this call.");
            }
            MimicReplayingSubListSelector.this.recordingAlreadyReturned = true;
            return MimicReplayingSubListSelector.this.recording;
        }

        public String toString() {
            if (MimicReplayingSubListSelector.this.hasRecordingCreated && !MimicReplayingSubListSelector.this.hasRecording) {
                return "No next replay";
            }
            return "Next replay (" + String.valueOf(MimicReplayingSubListSelector.this.recordingCreated ? MimicReplayingSubListSelector.this.recording : "?") + ")";
        }
    }
}

