/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.iterator;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class UpcomingSelectionIterator<S>
extends SelectionIterator<S> {
    protected boolean upcomingCreated = false;
    protected boolean hasUpcomingSelection = true;
    protected S upcomingSelection;

    @Override
    public boolean hasNext() {
        if (!this.upcomingCreated) {
            this.upcomingSelection = this.createUpcomingSelection();
            this.upcomingCreated = true;
        }
        return this.hasUpcomingSelection;
    }

    @Override
    public S next() {
        if (!this.hasUpcomingSelection) {
            throw new NoSuchElementException();
        }
        if (!this.upcomingCreated) {
            this.upcomingSelection = this.createUpcomingSelection();
        }
        this.upcomingCreated = false;
        return this.upcomingSelection;
    }

    protected abstract S createUpcomingSelection();

    protected S noUpcomingSelection() {
        this.hasUpcomingSelection = false;
        return null;
    }

    public String toString() {
        if (!this.upcomingCreated) {
            return "Next upcoming (?)";
        }
        if (!this.hasUpcomingSelection) {
            return "No next upcoming";
        }
        return "Next upcoming (" + String.valueOf(this.upcomingSelection) + ")";
    }

    public static ElementPosition findUnpinnedDestination(Iterator<ElementPosition> destinationIterator, ListVariableDescriptor<?> listVariableDescriptor) {
        while (destinationIterator.hasNext()) {
            ElementPosition destination = destinationIterator.next();
            if (destination instanceof PositionInList) {
                PositionInList positionInList = (PositionInList)destination;
                boolean isPinned = listVariableDescriptor.isElementPinned(null, positionInList.entity(), positionInList.index());
                if (isPinned) continue;
                return destination;
            }
            return destination;
        }
        return null;
    }
}

