/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.descriptor;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.InverseRelationShadowVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.PlanningPinToIndexReader;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateDemand;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.util.MutableLong;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class ListVariableDescriptor<Solution_>
extends GenuineVariableDescriptor<Solution_> {
    private final ListVariableStateDemand<Solution_> stateDemand = new ListVariableStateDemand(this);
    private final BiPredicate<Object, Object> inListPredicate = (element, entity) -> {
        Object list = this.getValue(entity);
        return list.contains(element);
    };
    private final BiPredicate<Object, Object> entityContainsPinnedValuePredicate = (value, entity) -> {
        EntityDescriptor parentEntityDescriptor = this.getEntityDescriptor();
        boolean entityMovable = parentEntityDescriptor.isMovable(null, entity);
        int pinToIndex = entityMovable ? parentEntityDescriptor.getEffectivePlanningPinToIndexReader().applyAsInt(entity) : Integer.MAX_VALUE;
        int valueIndex = this.getValue(entity).indexOf(value);
        if (valueIndex < 0) {
            return false;
        }
        return valueIndex < pinToIndex;
    };
    private boolean allowsUnassignedValues = true;

    public ListVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
    }

    public ListVariableStateDemand<Solution_> getStateDemand() {
        return this.stateDemand;
    }

    public <A> BiPredicate<A, Object> getInListPredicate() {
        return this.inListPredicate;
    }

    public <A, B> BiPredicate<A, B> getEntityContainsPinnedValuePredicate() {
        return this.entityContainsPinnedValuePredicate;
    }

    public boolean allowsUnassignedValues() {
        return this.allowsUnassignedValues;
    }

    @Override
    protected void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningListVariable planningVariableAnnotation = this.variableMemberAccessor.getAnnotation(PlanningListVariable.class);
        this.allowsUnassignedValues = planningVariableAnnotation.allowsUnassignedValues();
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation.valueRangeProviderRefs());
    }

    @Override
    protected void processValueRangeRefs(DescriptorPolicy descriptorPolicy, String[] valueRangeProviderRefs) {
        List<String> fromEntityValueRangeProviderRefs = Arrays.stream(valueRangeProviderRefs).filter(descriptorPolicy::hasFromEntityValueRangeProvider).toList();
        if (!fromEntityValueRangeProviderRefs.isEmpty()) {
            throw new IllegalArgumentException("@%s on a @%s is not supported with a list variable (%s).\nMaybe move the valueRangeProvider(s) (%s) from the entity class to the @%s class.".formatted(ValueRangeProvider.class.getSimpleName(), PlanningEntity.class.getSimpleName(), this, fromEntityValueRangeProviderRefs, PlanningSolution.class.getSimpleName()));
        }
        super.processValueRangeRefs(descriptorPolicy, valueRangeProviderRefs);
    }

    @Override
    public boolean acceptsValueType(Class<?> valueType) {
        return this.getElementType().isAssignableFrom(valueType);
    }

    @Override
    public boolean isInitialized(Object entity) {
        return true;
    }

    public Class<?> getElementType() {
        return ConfigUtils.extractGenericTypeParameterOrFail("entityClass", this.entityDescriptor.getEntityClass(), this.variableMemberAccessor.getType(), this.variableMemberAccessor.getGenericType(), PlanningListVariable.class, this.variableMemberAccessor.getName());
    }

    public int countUnassigned(Solution_ solution) {
        MutableLong valueCount = new MutableLong(this.getValueRangeSize(solution, null));
        SolutionDescriptor<Solution_> solutionDescriptor = this.entityDescriptor.getSolutionDescriptor();
        solutionDescriptor.visitEntitiesByEntityClass(solution, this.entityDescriptor.getEntityClass(), entity -> {
            Object assignedValues = this.getValue(entity);
            valueCount.subtract(assignedValues.size());
            return false;
        });
        return valueCount.intValue();
    }

    public InverseRelationShadowVariableDescriptor<Solution_> getInverseRelationShadowVariableDescriptor() {
        EntityDescriptor inverseRelationEntityDescriptor = this.getEntityDescriptor().getSolutionDescriptor().findEntityDescriptor(this.getElementType());
        if (inverseRelationEntityDescriptor == null) {
            return null;
        }
        List<ShadowVariableDescriptor> applicableShadowDescriptors = inverseRelationEntityDescriptor.getShadowVariableDescriptors().stream().filter(f -> {
            InverseRelationShadowVariableDescriptor inverseRelationShadowVariableDescriptor;
            return f instanceof InverseRelationShadowVariableDescriptor && Objects.equals((inverseRelationShadowVariableDescriptor = (InverseRelationShadowVariableDescriptor)f).getSourceVariableDescriptorList().get(0), this);
        }).toList();
        if (applicableShadowDescriptors.isEmpty()) {
            return null;
        }
        if (applicableShadowDescriptors.size() > 1) {
            throw new IllegalStateException("Instances of entityClass (%s) may be used in list variable (%s), but the class has more than one @%s-annotated field (%s).\nRemove the annotations from all but one field.".formatted(inverseRelationEntityDescriptor.getEntityClass().getCanonicalName(), this.getSimpleEntityAndVariableName(), InverseRelationShadowVariable.class.getSimpleName(), applicableShadowDescriptors.stream().map(VariableDescriptor::getSimpleEntityAndVariableName).collect(Collectors.joining(", ", "[", "]"))));
        }
        return (InverseRelationShadowVariableDescriptor)applicableShadowDescriptors.get(0);
    }

    @Override
    public List<Object> getValue(Object entity) {
        Object value = super.getValue(entity);
        if (value == null) {
            throw new IllegalStateException("The planning list variable (%s) of entity (%s) is null.".formatted(this, entity));
        }
        return (List)value;
    }

    public Object removeElement(Object entity, int index) {
        return this.getValue(entity).remove(index);
    }

    public void addElement(Object entity, int index, Object element) {
        this.getValue(entity).add(index, element);
    }

    public <Value_> Value_ getElement(Object entity, int index) {
        Object values = this.getValue(entity);
        if (index >= values.size()) {
            throw new IndexOutOfBoundsException("Impossible state: The index (%s) must be less than the size (%s) of the planning list variable (%s) of entity (%s).".formatted(index, values.size(), this, entity));
        }
        return (Value_)values.get(index);
    }

    public <Value_> Value_ setElement(Object entity, int index, Value_ element) {
        return this.getValue(entity).set(index, element);
    }

    public int getListSize(Object entity) {
        return this.getValue(entity).size();
    }

    public boolean supportsPinning() {
        return this.entityDescriptor.supportsPinning();
    }

    public boolean isElementPinned(Solution_ workingSolution, Object entity, int index) {
        if (!this.supportsPinning()) {
            return false;
        }
        if (!this.entityDescriptor.isMovable(workingSolution, entity)) {
            return true;
        }
        return index < this.getFirstUnpinnedIndex(entity);
    }

    public Object getRandomUnpinnedElement(Object entity, Random workingRandom) {
        Object listVariable = this.getValue(entity);
        int firstUnpinnedIndex = this.getFirstUnpinnedIndex(entity);
        return listVariable.get(workingRandom.nextInt(listVariable.size() - firstUnpinnedIndex) + firstUnpinnedIndex);
    }

    public int getUnpinnedSubListSize(Object entity) {
        int listSize = this.getListSize(entity);
        int firstUnpinnedIndex = this.getFirstUnpinnedIndex(entity);
        return listSize - firstUnpinnedIndex;
    }

    public List<Object> getUnpinnedSubList(Object entity) {
        int firstUnpinnedIndex = this.getFirstUnpinnedIndex(entity);
        Object entityList = this.getValue(entity);
        if (firstUnpinnedIndex == 0) {
            return entityList;
        }
        return entityList.subList(firstUnpinnedIndex, entityList.size());
    }

    public int getFirstUnpinnedIndex(Object entity) {
        PlanningPinToIndexReader effectivePlanningPinToIndexReader = this.entityDescriptor.getEffectivePlanningPinToIndexReader();
        if (effectivePlanningPinToIndexReader == null) {
            return 0;
        }
        return effectivePlanningPinToIndexReader.applyAsInt(entity);
    }
}

