/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSession;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariablePair;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultShadowVariableSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final IntFunction<TopologicalOrderGraph> graphCreator;

    public DefaultShadowVariableSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.solutionDescriptor = solutionDescriptor;
        this.scoreDirector = scoreDirector;
        this.graphCreator = graphCreator;
    }

    public static <Solution_> VariableReferenceGraph<Solution_> buildGraph(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        if (declarativeShadowVariableDescriptors.isEmpty()) {
            return EmptyVariableReferenceGraph.INSTANCE;
        }
        HashMap variableIdToUpdater = new HashMap();
        Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap = DefaultShadowVariableSessionFactory.createGraphNodes(variableReferenceGraphBuilder, entities, declarativeShadowVariableDescriptors, variableIdToUpdater);
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable : declarativeShadowVariableDescriptors) {
            VariableMetaModel fromVariableId = declarativeShadowVariable.getVariableMetaModel();
            DefaultShadowVariableSessionFactory.createSourceChangeProcessors(entities, variableReferenceGraphBuilder, declarativeShadowVariable, fromVariableId);
            Set<VariableSourceReference> aliasSet = declarativeShadowVariableToAliasMap.get(fromVariableId);
            if (aliasSet == null) continue;
            DefaultShadowVariableSessionFactory.createAliasToVariableChangeProcessors(variableReferenceGraphBuilder, aliasSet, fromVariableId);
        }
        DefaultShadowVariableSessionFactory.createFixedVariableRelationEdges(variableReferenceGraphBuilder, entities, declarativeShadowVariableDescriptors);
        return variableReferenceGraphBuilder.build(graphCreator);
    }

    private static <Solution_> Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> createGraphNodes(VariableReferenceGraphBuilder<Solution_> graph, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Map<VariableMetaModel<?, ?, ?>, VariableUpdaterInfo<Solution_>> variableIdToUpdater) {
        HashMap result = new HashMap();
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel variableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                VariableUpdaterInfo updater = variableIdToUpdater.computeIfAbsent(variableId, ignored -> new VariableUpdaterInfo(variableId, declarativeShadowVariableDescriptor, declarativeShadowVariableDescriptor.getEntityDescriptor().getShadowVariableLoopedDescriptor(), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter));
                graph.addVariableReferenceEntity(entity, updater);
                for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (source.downstreamDeclarativeVariableMetamodel() == null) continue;
                        result.computeIfAbsent(source.downstreamDeclarativeVariableMetamodel(), ignored -> new LinkedHashSet()).add(source);
                    }
                }
            }
        }
        return result;
    }

    private static <Solution_> void createSourceChangeProcessors(Object[] entities, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (RootVariableSource<?, ?> source : declarativeShadowVariable.getSources()) {
            for (VariableSourceReference sourcePart : source.variableSourceReferences()) {
                VariableMetaModel<?, ?, ?> toVariableId = sourcePart.variableMetaModel();
                if (sourcePart.isDeclarative()) continue;
                if (sourcePart.onRootEntity()) {
                    variableReferenceGraphBuilder.addAfterProcessor(toVariableId, (graph, entity) -> {
                        EntityVariablePair changed = graph.lookupOrNull(fromVariableId, entity);
                        if (changed != null) {
                            graph.markChanged(changed);
                        }
                    });
                    continue;
                }
                IdentityHashMap inverseMap = new IdentityHashMap();
                BiConsumer<Object, Consumer<Object>> visitor = source.getEntityVisitor(sourcePart.chainToVariableEntity());
                for (Object rootEntity : entities) {
                    if (!declarativeShadowVariable.getEntityDescriptor().getEntityClass().isInstance(rootEntity)) continue;
                    visitor.accept(rootEntity, shadowEntity -> inverseMap.computeIfAbsent(shadowEntity, ignored -> new ArrayList()).add(rootEntity));
                }
                variableReferenceGraphBuilder.addAfterProcessor(toVariableId, (graph, entity) -> {
                    for (Object item : inverseMap.getOrDefault(entity, Collections.emptyList())) {
                        EntityVariablePair changed = graph.lookupOrNull(fromVariableId, item);
                        if (changed == null) continue;
                        graph.markChanged(changed);
                    }
                });
            }
        }
    }

    private static <Solution_> void createAliasToVariableChangeProcessors(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Set<VariableSourceReference> aliasSet, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (VariableSourceReference alias : aliasSet) {
            VariableMetaModel<?, ?, ?> toVariableId = alias.targetVariableMetamodel();
            VariableMetaModel<?, ?, ?> sourceVariableId = alias.variableMetaModel();
            if (alias.isDeclarative() || !alias.affectGraphEdges()) continue;
            variableReferenceGraphBuilder.addBeforeProcessor(sourceVariableId, (graph, toEntity) -> {
                EntityVariablePair to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.targetEntityFunctionStartingFromVariableEntity().apply(toEntity);
                if (fromEntity == null) {
                    return;
                }
                EntityVariablePair from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.removeEdge(from, to);
            });
            variableReferenceGraphBuilder.addAfterProcessor(sourceVariableId, (graph, toEntity) -> {
                EntityVariablePair to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.findTargetEntity(toEntity);
                if (fromEntity == null) {
                    return;
                }
                EntityVariablePair from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.addEdge(from, to);
            });
        }
    }

    private static <Solution_> void createFixedVariableRelationEdges(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors) {
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel toVariableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                EntityVariablePair to = variableReferenceGraphBuilder.lookupOrError(toVariableId, entity);
                block2: for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (!source.isTopLevel() || !source.isDeclarative()) continue;
                        VariableMetaModel<?, ?, ?> fromVariableId = source.variableMetaModel();
                        sourceRoot.valueEntityFunction().accept(entity, fromEntity -> {
                            EntityVariablePair from = variableReferenceGraphBuilder.lookupOrError(fromVariableId, fromEntity);
                            variableReferenceGraphBuilder.addFixedEdge(from, to);
                        });
                        continue block2;
                    }
                }
            }
        }
    }

    public DefaultShadowVariableSession<Solution_> forSolution(Solution_ solution) {
        ArrayList entities = new ArrayList();
        this.solutionDescriptor.visitAllEntities(solution, entities::add);
        return this.forEntities(entities.toArray());
    }

    public DefaultShadowVariableSession<Solution_> forEntities(Object ... entities) {
        VariableReferenceGraphBuilder<Solution_> builder = new VariableReferenceGraphBuilder<Solution_>(ChangedVariableNotifier.of(this.scoreDirector));
        VariableReferenceGraph<Solution_> graph = DefaultShadowVariableSessionFactory.buildGraph(this.solutionDescriptor, builder, entities, this.graphCreator);
        return new DefaultShadowVariableSession<Solution_>(graph);
    }
}

