/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariablePair;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariableLoopedVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.util.LinkedIdentityHashSet;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

final class AffectedEntitiesUpdater<Solution_>
implements Consumer<BitSet> {
    private final BaseTopologicalOrderGraph graph;
    private final List<EntityVariablePair<Solution_>> instanceList;
    private final Function<Object, List<EntityVariablePair<Solution_>>> entityVariablePairFunction;
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private final AffectedEntities<Solution_> affectedEntities;
    private final LoopedTracker loopedTracker;
    private final BitSet visited;
    private final PriorityQueue<BaseTopologicalOrderGraph.NodeTopologicalOrder> changeQueue;

    AffectedEntitiesUpdater(BaseTopologicalOrderGraph graph, List<EntityVariablePair<Solution_>> instanceList, Function<Object, List<EntityVariablePair<Solution_>>> entityVariablePairFunction, ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.graph = graph;
        this.instanceList = instanceList;
        this.entityVariablePairFunction = entityVariablePairFunction;
        this.changedVariableNotifier = changedVariableNotifier;
        int instanceCount = instanceList.size();
        this.affectedEntities = new AffectedEntities(this::updateLoopedStatusOfAffectedEntity);
        this.loopedTracker = new LoopedTracker(instanceCount);
        this.visited = new BitSet(instanceCount);
        this.changeQueue = new PriorityQueue(instanceCount);
    }

    @Override
    public void accept(BitSet changed) {
        this.initializeChangeQueue(changed);
        while (!this.changeQueue.isEmpty()) {
            int nextNode = this.changeQueue.poll().nodeId();
            if (this.visited.get(nextNode)) continue;
            this.visited.set(nextNode);
            EntityVariablePair<Solution_> shadowVariable = this.instanceList.get(nextNode);
            boolean isChanged = this.updateShadowVariable(shadowVariable, this.graph.isLooped(this.loopedTracker, nextNode));
            if (!isChanged) continue;
            PrimitiveIterator.OfInt iterator = this.graph.nodeForwardEdges(nextNode);
            while (iterator.hasNext()) {
                int nextNodeForwardEdge = iterator.nextInt();
                if (this.visited.get(nextNodeForwardEdge)) continue;
                this.changeQueue.add(this.graph.getTopologicalOrder(nextNodeForwardEdge));
            }
        }
        this.affectedEntities.processAndClear();
        this.loopedTracker.clear();
        this.visited.clear();
    }

    private void initializeChangeQueue(BitSet changed) {
        int i = changed.nextSetBit(0);
        while (i >= 0) {
            this.changeQueue.add(this.graph.getTopologicalOrder(i));
            if (i == Integer.MAX_VALUE) break;
            i = changed.nextSetBit(i + 1);
        }
        changed.clear();
    }

    private void updateLoopedStatusOfAffectedEntity(Object affectedEntity) {
        ShadowVariableLoopedVariableDescriptor<Solution_> shadowVariableLoopedDescriptor = null;
        boolean isEntityLooped = false;
        for (EntityVariablePair<Solution_> node : this.entityVariablePairFunction.apply(affectedEntity)) {
            shadowVariableLoopedDescriptor = node.variableReference().shadowVariableLoopedDescriptor();
            if (!this.graph.isLooped(this.loopedTracker, node.graphNodeId())) continue;
            isEntityLooped = true;
            break;
        }
        if (shadowVariableLoopedDescriptor == null) {
            throw new IllegalStateException("Impossible state: loop marker descriptor does not exist.");
        }
        Object oldValue = shadowVariableLoopedDescriptor.getValue(affectedEntity);
        if (!Objects.equals(oldValue, isEntityLooped)) {
            this.changeShadowVariableAndNotify(shadowVariableLoopedDescriptor, affectedEntity, (Object)isEntityLooped);
        }
    }

    private boolean updateShadowVariable(EntityVariablePair<Solution_> entityVariable, boolean isLooped) {
        boolean oldLooped;
        Object entity = entityVariable.entity();
        VariableUpdaterInfo<Solution_> shadowVariableReference = entityVariable.variableReference();
        Object oldValue = shadowVariableReference.memberAccessor().executeGetter(entity);
        ShadowVariableLoopedVariableDescriptor<Solution_> loopDescriptor = shadowVariableReference.shadowVariableLoopedDescriptor();
        if (loopDescriptor != null && (oldLooped = ((Boolean)loopDescriptor.getValue(entity)).booleanValue()) != isLooped) {
            this.affectedEntities.add(entityVariable);
        }
        if (isLooped) {
            if (oldValue != null) {
                this.affectedEntities.add(entityVariable);
                this.changeShadowVariableAndNotify(shadowVariableReference, entity, null);
            }
            return true;
        }
        Object newValue = shadowVariableReference.calculator().apply(entity);
        if (!Objects.equals(oldValue, newValue)) {
            this.affectedEntities.add(entityVariable);
            this.changeShadowVariableAndNotify(shadowVariableReference, entity, newValue);
            return true;
        }
        return false;
    }

    private void changeShadowVariableAndNotify(VariableUpdaterInfo<Solution_> shadowVariableReference, Object entity, Object newValue) {
        DeclarativeShadowVariableDescriptor<Solution_> variableDescriptor = shadowVariableReference.variableDescriptor();
        this.changeShadowVariableAndNotify(variableDescriptor, entity, newValue);
    }

    private void changeShadowVariableAndNotify(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.changedVariableNotifier.beforeVariableChanged().accept(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.changedVariableNotifier.afterVariableChanged().accept(variableDescriptor, entity);
    }

    private static final class AffectedEntities<Solution_> {
        private final Consumer<Object> consumer;
        private final Set<Object> entitiesForLoopedVarUpdateSet;

        public AffectedEntities(Consumer<Object> consumer) {
            this.consumer = consumer;
            this.entitiesForLoopedVarUpdateSet = new LinkedIdentityHashSet<Object>();
        }

        public void add(EntityVariablePair<Solution_> shadowVariable) {
            ShadowVariableLoopedVariableDescriptor<Solution_> shadowVariableLoopedDescriptor = shadowVariable.variableReference().shadowVariableLoopedDescriptor();
            if (shadowVariableLoopedDescriptor == null) {
                return;
            }
            this.entitiesForLoopedVarUpdateSet.add(shadowVariable.entity());
        }

        public void processAndClear() {
            for (Object entity : this.entitiesForLoopedVarUpdateSet) {
                this.consumer.accept(entity);
            }
            this.entitiesForLoopedVarUpdateSet.clear();
        }
    }
}

