/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.ListVariableState;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.NonNull;

final class ExternalizedListVariableStateSupply<Solution_>
implements ListVariableStateSupply<Solution_> {
    private final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private final ListVariableState<Solution_> listVariableState;
    private boolean previousExternalized = false;
    private boolean nextExternalized = false;
    private Solution_ workingSolution;

    public ExternalizedListVariableStateSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
        this.listVariableState = new ListVariableState<Solution_>(sourceVariableDescriptor);
    }

    @Override
    public void externalize(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
    }

    @Override
    public void externalize(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
    }

    @Override
    public void externalize(PreviousElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
        this.previousExternalized = true;
    }

    @Override
    public void externalize(NextElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
        this.nextExternalized = true;
    }

    @Override
    public void resetWorkingSolution(@NonNull ScoreDirector<Solution_> scoreDirector) {
        this.workingSolution = scoreDirector.getWorkingSolution();
        this.listVariableState.initialize((InnerScoreDirector)scoreDirector, (int)this.sourceVariableDescriptor.getValueRangeSize(this.workingSolution, null));
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(this.workingSolution, this::insert);
    }

    private void insert(Object entity) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        int index = 0;
        Iterator iterator = assignedElements.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.listVariableState.addElement(entity, (List<Object>)assignedElements, element, index);
            ++index;
        }
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        for (int index = 0; index < assignedElements.size(); ++index) {
            this.listVariableState.removeElement(entity, assignedElements.get(index), index);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object element) {
        this.listVariableState.unassignElement(element);
    }

    @Override
    public void beforeListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity, int fromIndex, int toIndex) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        int elementCount = assignedElements.size();
        int firstChangeIndex = this.nextExternalized ? Math.max(0, fromIndex - 1) : fromIndex;
        int lastChangeIndex = this.previousExternalized ? Math.min(toIndex + 1, elementCount) : toIndex;
        for (int index = firstChangeIndex; index < elementCount; ++index) {
            boolean positionsDiffer = this.listVariableState.changeElement(entity, (List<Object>)assignedElements, index);
            if (positionsDiffer || index < lastChangeIndex) continue;
            return;
        }
    }

    @Override
    public ElementPosition getElementPosition(Object planningValue) {
        return this.listVariableState.getElementPosition(planningValue);
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.listVariableState.getIndex(planningValue);
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.listVariableState.getInverseSingleton(planningValue);
    }

    @Override
    public boolean isAssigned(Object element) {
        return this.getInverseSingleton(element) != null;
    }

    @Override
    public boolean isPinned(Object element) {
        if (!this.sourceVariableDescriptor.supportsPinning()) {
            return false;
        }
        ElementPosition position = this.getElementPosition(element);
        if (position instanceof PositionInList) {
            PositionInList assignedPosition = (PositionInList)position;
            return this.sourceVariableDescriptor.isElementPinned(this.workingSolution, assignedPosition.entity(), assignedPosition.index());
        }
        return false;
    }

    @Override
    public int getUnassignedCount() {
        return this.listVariableState.getUnassignedCount();
    }

    @Override
    public Object getPreviousElement(Object element) {
        return this.listVariableState.getPreviousElement(element);
    }

    @Override
    public Object getNextElement(Object element) {
        return this.listVariableState.getNextElement(element);
    }

    @Override
    public ListVariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

