/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.api.solver.SolverStatus;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jspecify.annotations.NonNull;

public interface SolverJob<Solution_, ProblemId_> {
    public @NonNull ProblemId_ getProblemId();

    public @NonNull SolverStatus getSolverStatus();

    default public @NonNull CompletableFuture<Void> addProblemChange(@NonNull ProblemChange<Solution_> problemChange) {
        return this.addProblemChanges(Collections.singletonList(problemChange));
    }

    public @NonNull CompletableFuture<Void> addProblemChanges(@NonNull List<ProblemChange<Solution_>> var1);

    public void terminateEarly();

    public boolean isTerminatedEarly();

    public @NonNull Solution_ getFinalBestSolution() throws InterruptedException, ExecutionException;

    public @NonNull Duration getSolvingDuration();

    public long getScoreCalculationCount();

    public long getMoveEvaluationCount();

    public @NonNull ProblemSizeStatistics getProblemSizeStatistics();

    public long getScoreCalculationSpeed();

    public long getMoveEvaluationSpeed();
}

