/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.scope;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.change.DefaultProblemChangeDirector;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.impl.util.MathUtils;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SolverScope<Solution_> {
    private final Clock clock;
    private final AtomicReference<ProblemSizeStatistics> problemSizeStatistics = new AtomicReference();
    private final AtomicReference<Solution_> bestSolution = new AtomicReference();
    private final AtomicReference<InnerScore<?>> bestScore = new AtomicReference();
    private final AtomicLong startingSystemTimeMillis = SolverScope.resetAtomicLongTimeMillis(new AtomicLong());
    private final AtomicLong endingSystemTimeMillis = SolverScope.resetAtomicLongTimeMillis(new AtomicLong());
    private Set<SolverMetric> solverMetricSet = Collections.emptySet();
    private Tags monitoringTags;
    private int startingSolverCount;
    private Random workingRandom;
    private InnerScoreDirector<Solution_, ?> scoreDirector;
    private AbstractSolver<Solution_> solver;
    private DefaultProblemChangeDirector<Solution_> problemChangeDirector;
    private Semaphore runnableThreadSemaphore = null;
    private long childThreadsScoreCalculationCount = 0L;
    private long moveEvaluationCount = 0L;
    private Score<?> startingInitializedScore;
    private Long bestSolutionTimeMillis;
    private final Map<Tags, List<AtomicReference<Number>>> stepScoreMap = new ConcurrentHashMap<Tags, List<AtomicReference<Number>>>();
    private final Map<String, Long> moveEvaluationCountPerTypeMap = new ConcurrentHashMap<String, Long>();

    private static AtomicLong resetAtomicLongTimeMillis(AtomicLong atomicLong) {
        atomicLong.set(-1L);
        return atomicLong;
    }

    private static Long readAtomicLongTimeMillis(AtomicLong atomicLong) {
        long value = atomicLong.get();
        return value == -1L ? null : Long.valueOf(value);
    }

    public SolverScope() {
        this.clock = Clock.systemDefaultZone();
    }

    public SolverScope(Clock clock) {
        this.clock = Objects.requireNonNull(clock);
    }

    public Clock getClock() {
        return this.clock;
    }

    public AbstractSolver<Solution_> getSolver() {
        return this.solver;
    }

    public void setSolver(AbstractSolver<Solution_> solver) {
        this.solver = solver;
    }

    public DefaultProblemChangeDirector<Solution_> getProblemChangeDirector() {
        return this.problemChangeDirector;
    }

    public void setProblemChangeDirector(DefaultProblemChangeDirector<Solution_> problemChangeDirector) {
        this.problemChangeDirector = problemChangeDirector;
    }

    public Tags getMonitoringTags() {
        return this.monitoringTags;
    }

    public void setMonitoringTags(Tags monitoringTags) {
        this.monitoringTags = monitoringTags;
    }

    public Map<Tags, List<AtomicReference<Number>>> getStepScoreMap() {
        return this.stepScoreMap;
    }

    public Set<SolverMetric> getSolverMetricSet() {
        return this.solverMetricSet;
    }

    public void setSolverMetricSet(EnumSet<SolverMetric> solverMetricSet) {
        this.solverMetricSet = solverMetricSet;
    }

    public int getStartingSolverCount() {
        return this.startingSolverCount;
    }

    public void setStartingSolverCount(int startingSolverCount) {
        this.startingSolverCount = startingSolverCount;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public <Score_ extends Score<Score_>> InnerScoreDirector<Solution_, Score_> getScoreDirector() {
        return this.scoreDirector;
    }

    public void setScoreDirector(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    public void setRunnableThreadSemaphore(Semaphore runnableThreadSemaphore) {
        this.runnableThreadSemaphore = runnableThreadSemaphore;
    }

    public Long getStartingSystemTimeMillis() {
        return SolverScope.readAtomicLongTimeMillis(this.startingSystemTimeMillis);
    }

    public Long getEndingSystemTimeMillis() {
        return SolverScope.readAtomicLongTimeMillis(this.endingSystemTimeMillis);
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.scoreDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirector.getScoreDefinition();
    }

    public Solution_ getWorkingSolution() {
        return this.scoreDirector.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.scoreDirector.getWorkingGenuineEntityCount();
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> calculateScore() {
        return this.getScoreDirector().calculateScore();
    }

    public void assertScoreFromScratch(Solution_ solution) {
        this.scoreDirector.getScoreDirectorFactory().assertScoreFromScratch(solution);
    }

    public <Score_ extends Score<Score_>> Score_ getStartingInitializedScore() {
        return (Score_)this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score<?> startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public void addChildThreadsScoreCalculationCount(long addition) {
        this.childThreadsScoreCalculationCount += addition;
    }

    public long getScoreCalculationCount() {
        return this.scoreDirector.getCalculationCount() + this.childThreadsScoreCalculationCount;
    }

    public void addMoveEvaluationCount(long addition) {
        this.moveEvaluationCount += addition;
    }

    public long getMoveEvaluationCount() {
        return this.moveEvaluationCount;
    }

    public Solution_ getBestSolution() {
        return this.bestSolution.get();
    }

    public void setBestSolution(Solution_ bestSolution) {
        this.bestSolution.set(bestSolution);
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getBestScore() {
        return this.bestScore.get();
    }

    public <Score_ extends Score<Score_>> void setInitializedBestScore(Score_ bestScore) {
        this.setBestScore(InnerScore.fullyAssigned(bestScore));
    }

    public <Score_ extends Score<Score_>> void setBestScore(InnerScore<Score_> bestScore) {
        this.bestScore.set(bestScore);
    }

    public Long getBestSolutionTimeMillis() {
        return this.bestSolutionTimeMillis;
    }

    public void setBestSolutionTimeMillis(Long bestSolutionTimeMillis) {
        this.bestSolutionTimeMillis = bestSolutionTimeMillis;
    }

    public Set<String> getMoveCountTypes() {
        return this.moveEvaluationCountPerTypeMap.keySet();
    }

    public Map<String, Long> getMoveEvaluationCountPerType() {
        return this.moveEvaluationCountPerTypeMap;
    }

    public boolean isMetricEnabled(SolverMetric solverMetric) {
        return this.solverMetricSet.contains((Object)solverMetric);
    }

    public void startingNow() {
        this.startingSystemTimeMillis.set(this.getClock().millis());
        SolverScope.resetAtomicLongTimeMillis(this.endingSystemTimeMillis);
        this.moveEvaluationCount = 0L;
    }

    public Long getBestSolutionTimeMillisSpent() {
        return this.getBestSolutionTimeMillis() - this.getStartingSystemTimeMillis();
    }

    public void endingNow() {
        this.endingSystemTimeMillis.set(this.getClock().millis());
    }

    public boolean isBestSolutionInitialized() {
        return this.getBestScore().fullyAssigned();
    }

    public long calculateTimeMillisSpentUpToNow() {
        long now = this.getClock().millis();
        return now - this.getStartingSystemTimeMillis();
    }

    public long getTimeMillisSpent() {
        Long startingMillis = this.getStartingSystemTimeMillis();
        if (startingMillis == null) {
            return 0L;
        }
        Long endingMillis = this.getEndingSystemTimeMillis();
        if (endingMillis == null) {
            endingMillis = this.getClock().millis();
        }
        return endingMillis - startingMillis;
    }

    public ProblemSizeStatistics getProblemSizeStatistics() {
        return this.problemSizeStatistics.get();
    }

    public void setProblemSizeStatistics(ProblemSizeStatistics problemSizeStatistics) {
        this.problemSizeStatistics.set(problemSizeStatistics);
    }

    public long getScoreCalculationSpeed() {
        long timeMillisSpent = this.getTimeMillisSpent();
        return MathUtils.getSpeed(this.getScoreCalculationCount(), timeMillisSpent);
    }

    public long getMoveEvaluationSpeed() {
        long timeMillisSpent = this.getTimeMillisSpent();
        return MathUtils.getSpeed(this.getMoveEvaluationCount(), timeMillisSpent);
    }

    public void setWorkingSolutionFromBestSolution() {
        this.scoreDirector.setWorkingSolution(this.scoreDirector.cloneSolution(this.getBestSolution()));
    }

    public SolverScope<Solution_> createChildThreadSolverScope(ChildThreadType childThreadType) {
        SolverScope<Solution_> childThreadSolverScope = new SolverScope<Solution_>(this.clock);
        childThreadSolverScope.bestSolution.set(null);
        childThreadSolverScope.bestScore.set(null);
        childThreadSolverScope.monitoringTags = this.monitoringTags;
        childThreadSolverScope.solverMetricSet = this.solverMetricSet;
        childThreadSolverScope.startingSolverCount = this.startingSolverCount;
        childThreadSolverScope.workingRandom = new Random(this.workingRandom.nextLong());
        childThreadSolverScope.scoreDirector = this.scoreDirector.createChildThreadScoreDirector(childThreadType);
        childThreadSolverScope.startingSystemTimeMillis.set(this.startingSystemTimeMillis.get());
        SolverScope.resetAtomicLongTimeMillis(childThreadSolverScope.endingSystemTimeMillis);
        childThreadSolverScope.startingInitializedScore = null;
        childThreadSolverScope.bestSolutionTimeMillis = null;
        return childThreadSolverScope;
    }

    public void initializeYielding() {
        if (this.runnableThreadSemaphore != null) {
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void checkYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
            try {
                this.runnableThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void destroyYielding() {
        if (this.runnableThreadSemaphore != null) {
            this.runnableThreadSemaphore.release();
        }
    }

    public void addMoveEvaluationCountPerType(String moveType, long count) {
        this.moveEvaluationCountPerTypeMap.compute(moveType, (key, counter) -> {
            if (counter == null) {
                counter = 0L;
            }
            counter = counter + count;
            return counter;
        });
    }
}

