/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.RuinedLocation;
import ai.timefold.solver.core.impl.move.director.VariableChangeRecordingScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public final class ListRuinRecreateMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final List<Object> ruinedValueList;
    private final Set<Object> affectedEntitySet;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final Map<Object, NavigableSet<RuinedLocation>> entityToNewPositionMap;

    public ListRuinRecreateMove(ListVariableDescriptor<Solution_> listVariableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, List<Object> ruinedValueList, Set<Object> affectedEntitySet) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.ruinedValueList = ruinedValueList;
        this.affectedEntitySet = affectedEntitySet;
        this.entityToNewPositionMap = CollectionUtils.newIdentityHashMap(affectedEntitySet.size());
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        this.entityToNewPositionMap.clear();
        VariableChangeRecordingScoreDirector variableChangeRecordingScoreDirector = (VariableChangeRecordingScoreDirector)scoreDirector;
        try (ListVariableStateSupply listVariableStateSupply = (ListVariableStateSupply)variableChangeRecordingScoreDirector.getBacking().getSupplyManager().demand(this.listVariableDescriptor.getStateDemand());){
            Map<Object, NavigableSet> entityToOriginalPositionMap = CollectionUtils.newIdentityHashMap(this.affectedEntitySet.size());
            for (Object object : this.ruinedValueList) {
                LocationInList location = listVariableStateSupply.getLocationInList(object).ensureAssigned();
                entityToOriginalPositionMap.computeIfAbsent(location.entity(), ignored -> new TreeSet()).add(new RuinedLocation(object, location.index()));
            }
            InnerScoreDirector nonRecordingScoreDirector = variableChangeRecordingScoreDirector.getBacking();
            for (Map.Entry entry : entityToOriginalPositionMap.entrySet()) {
                Object entity = entry.getKey();
                Iterator<Object> originalPositionSet = (NavigableSet)entry.getValue();
                variableChangeRecordingScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, entity, this.listVariableDescriptor.getFirstUnpinnedIndex(entity), this.listVariableDescriptor.getListSize(entity));
                for (RuinedLocation ruinedLocation : originalPositionSet.descendingSet()) {
                    variableChangeRecordingScoreDirector.beforeListVariableElementUnassigned(this.listVariableDescriptor, ruinedLocation.ruinedValue());
                    this.listVariableDescriptor.removeElement(entity, ruinedLocation.index());
                    variableChangeRecordingScoreDirector.afterListVariableElementUnassigned(this.listVariableDescriptor, ruinedLocation.ruinedValue());
                }
                nonRecordingScoreDirector.afterListVariableChanged(this.listVariableDescriptor, entity, this.listVariableDescriptor.getFirstUnpinnedIndex(entity), this.listVariableDescriptor.getListSize(entity));
            }
            scoreDirector.triggerVariableListeners();
            RuinRecreateConstructionHeuristicPhase ruinRecreateConstructionHeuristicPhase = (RuinRecreateConstructionHeuristicPhase)this.constructionHeuristicPhaseBuilder.ensureThreadSafe(variableChangeRecordingScoreDirector.getBacking()).withElementsToRuin(entityToOriginalPositionMap.keySet()).withElementsToRecreate(this.ruinedValueList).build();
            SolverScope nestedSolverScope = new SolverScope(this.solverScope.getClock());
            nestedSolverScope.setSolver(this.solverScope.getSolver());
            nestedSolverScope.setScoreDirector(variableChangeRecordingScoreDirector.getBacking());
            ruinRecreateConstructionHeuristicPhase.solvingStarted(nestedSolverScope);
            ruinRecreateConstructionHeuristicPhase.solve(nestedSolverScope);
            ruinRecreateConstructionHeuristicPhase.solvingEnded(nestedSolverScope);
            scoreDirector.triggerVariableListeners();
            Map<Object, List> entityToInsertedValuesMap = CollectionUtils.newIdentityHashMap(0);
            for (Object entity : entityToOriginalPositionMap.keySet()) {
                entityToInsertedValuesMap.put(entity, new ArrayList());
            }
            for (Object ruinedValue : this.ruinedValueList) {
                LocationInList locationInList = listVariableStateSupply.getLocationInList(ruinedValue).ensureAssigned();
                this.entityToNewPositionMap.computeIfAbsent(locationInList.entity(), ignored -> new TreeSet()).add(new RuinedLocation(ruinedValue, locationInList.index()));
                entityToInsertedValuesMap.computeIfAbsent(locationInList.entity(), ignored -> new ArrayList()).add(ruinedValue);
            }
            VariableChangeRecordingScoreDirector onlyRecordingChangesScoreDirector = variableChangeRecordingScoreDirector.getNonDelegating();
            for (Map.Entry entry : entityToInsertedValuesMap.entrySet()) {
                if (!entityToOriginalPositionMap.containsKey(entry.getKey())) {
                    List<Object> originalElementList = ruinRecreateConstructionHeuristicPhase.getMissingUpdatedElementsMap().get(entry.getKey());
                    List currentElementList = List.copyOf(this.listVariableDescriptor.getValue(entry.getKey()));
                    this.listVariableDescriptor.getValue(entry.getKey()).clear();
                    this.listVariableDescriptor.getValue(entry.getKey()).addAll(originalElementList);
                    onlyRecordingChangesScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, entry.getKey(), 0, originalElementList.size());
                    this.listVariableDescriptor.getValue(entry.getKey()).clear();
                    this.listVariableDescriptor.getValue(entry.getKey()).addAll(currentElementList);
                }
                for (Object element : (List)entry.getValue()) {
                    onlyRecordingChangesScoreDirector.beforeListVariableElementAssigned(this.listVariableDescriptor, element);
                }
                onlyRecordingChangesScoreDirector.afterListVariableChanged(this.listVariableDescriptor, entry.getKey(), this.listVariableDescriptor.getFirstUnpinnedIndex(entry.getKey()), this.listVariableDescriptor.getListSize(entry.getKey()));
                for (Object element : (List)entry.getValue()) {
                    onlyRecordingChangesScoreDirector.afterListVariableElementAssigned(this.listVariableDescriptor, element);
                }
            }
            variableChangeRecordingScoreDirector.getBacking().getSupplyManager().cancel(this.listVariableDescriptor.getStateDemand());
        }
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return this.affectedEntitySet;
    }

    @Override
    public Collection<?> getPlanningValues() {
        return this.ruinedValueList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        List<Object> rebasedRuinedValueList = AbstractMove.rebaseList(this.ruinedValueList, destinationScoreDirector);
        Set<Object> rebasedAffectedEntitySet = AbstractMove.rebaseSet(this.affectedEntitySet, destinationScoreDirector);
        ListVariableDescriptor rebasedListVariableDescriptor = ((InnerScoreDirector)destinationScoreDirector).getSolutionDescriptor().getListVariableDescriptor();
        return new ListRuinRecreateMove(rebasedListVariableDescriptor, this.constructionHeuristicPhaseBuilder, this.solverScope, rebasedRuinedValueList, rebasedAffectedEntitySet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRuinRecreateMove)) {
            return false;
        }
        ListRuinRecreateMove that = (ListRuinRecreateMove)o;
        return Objects.equals(this.listVariableDescriptor, that.listVariableDescriptor) && Objects.equals(this.ruinedValueList, that.ruinedValueList) && Objects.equals(this.affectedEntitySet, that.affectedEntitySet);
    }

    public int hashCode() {
        return Objects.hash(this.listVariableDescriptor, this.ruinedValueList, this.affectedEntitySet);
    }

    public String toString() {
        return "ListRuinMove{values=" + String.valueOf(this.ruinedValueList) + ", newLocationsByEntity=" + String.valueOf(!this.entityToNewPositionMap.isEmpty() ? this.entityToNewPositionMap : "?") + "}";
    }
}

