/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

record EntityOrderInfo(Object[] entities, Map<Object, Integer> entityToEntityIndex, int[] offsets) {
    public static <Node_> EntityOrderInfo of(Node_[] pickedValues, ListVariableStateSupply<?> listVariableStateSupply) {
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        IdentityHashMap<Object, Integer> entityToEntityIndex = new IdentityHashMap<Object, Integer>();
        for (int i = 1; i < pickedValues.length && pickedValues[i] != null; ++i) {
            Node_ value = pickedValues[i];
            Iterator entity = listVariableStateSupply.getInverseSingleton(value);
            if (!listVariableDescriptor.getEntityDescriptor().isMovable(null, entity)) {
                throw new IllegalStateException("Impossible state: immovable entity (%s) picked through value (%s).".formatted(entity, value));
            }
            entityToEntityIndex.computeIfAbsent(entity, __ -> entityToEntityIndex.size());
        }
        Object[] entities = new Object[entityToEntityIndex.size()];
        int[] offsets = new int[entities.length];
        for (Map.Entry entityAndIndex : entityToEntityIndex.entrySet()) {
            entities[((Integer)entityAndIndex.getValue()).intValue()] = entityAndIndex.getKey();
        }
        for (int i = 1; i < offsets.length; ++i) {
            offsets[i] = offsets[i - 1] + ((ListVariableDescriptor)listVariableDescriptor).getListSize(entities[i - 1]);
        }
        return new EntityOrderInfo(entities, entityToEntityIndex, offsets);
    }

    public <Node_> EntityOrderInfo withNewNode(Node_ node, ListVariableStateSupply<?> listVariableStateSupply) {
        Object entity = listVariableStateSupply.getInverseSingleton(node);
        if (this.entityToEntityIndex.containsKey(entity)) {
            return this;
        }
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        Object[] newEntities = Arrays.copyOf(this.entities, this.entities.length + 1);
        IdentityHashMap<Object, Integer> newEntityToEntityIndex = new IdentityHashMap<Object, Integer>(this.entityToEntityIndex);
        int[] newOffsets = Arrays.copyOf(this.offsets, this.offsets.length + 1);
        newEntities[this.entities.length] = entity;
        newEntityToEntityIndex.put(entity, this.entities.length);
        newOffsets[this.entities.length] = this.offsets[this.entities.length - 1] + ((ListVariableDescriptor)listVariableDescriptor).getListSize(this.entities[this.entities.length - 1]);
        return new EntityOrderInfo(newEntities, newEntityToEntityIndex, newOffsets);
    }

    public <Node_> Node_ successor(Node_ object, ListVariableStateSupply<?> listVariableStateSupply) {
        Object listVariable;
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        LocationInList elementLocation = listVariableStateSupply.getLocationInList(object).ensureAssigned();
        Object entity = elementLocation.entity();
        int indexInEntityList = elementLocation.index();
        if (indexInEntityList == (listVariable = ((ListVariableDescriptor)listVariableDescriptor).getValue(entity)).size() - 1) {
            int nextEntityIndex = (this.entityToEntityIndex.get(entity) + 1) % this.entities.length;
            Object nextEntity = this.entities[nextEntityIndex];
            int firstUnpinnedIndexInList = ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(nextEntity);
            return (Node_)((ListVariableDescriptor)listVariableDescriptor).getElement(nextEntity, firstUnpinnedIndexInList);
        }
        return (Node_)listVariable.get(indexInEntityList + 1);
    }

    public <Node_> Node_ predecessor(Node_ object, ListVariableStateSupply<?> listVariableStateSupply) {
        int firstUnpinnedIndexInList;
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        LocationInList elementLocation = listVariableStateSupply.getLocationInList(object).ensureAssigned();
        Object entity = elementLocation.entity();
        int indexInEntityList = elementLocation.index();
        if (indexInEntityList == (firstUnpinnedIndexInList = ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(entity))) {
            int previousEntityIndex = (this.entityToEntityIndex.get(entity) - 1 + this.entities.length) % this.entities.length;
            Object listVariable = ((ListVariableDescriptor)listVariableDescriptor).getValue(this.entities[previousEntityIndex]);
            return (Node_)listVariable.get(listVariable.size() - 1);
        }
        return (Node_)((ListVariableDescriptor)listVariableDescriptor).getElement(entity, indexInEntityList - 1);
    }

    public <Node_> boolean between(Node_ start, Node_ middle, Node_ end, ListVariableStateSupply<?> listVariableStateSupply) {
        LocationInList startElementLocation = listVariableStateSupply.getLocationInList(start).ensureAssigned();
        LocationInList middleElementLocation = listVariableStateSupply.getLocationInList(middle).ensureAssigned();
        LocationInList endElementLocation = listVariableStateSupply.getLocationInList(end).ensureAssigned();
        int startEntityIndex = this.entityToEntityIndex.get(startElementLocation.entity());
        int middleEntityIndex = this.entityToEntityIndex.get(middleElementLocation.entity());
        int endEntityIndex = this.entityToEntityIndex.get(endElementLocation.entity());
        int startIndex = startElementLocation.index() + this.offsets[startEntityIndex];
        int middleIndex = middleElementLocation.index() + this.offsets[middleEntityIndex];
        int endIndex = endElementLocation.index() + this.offsets[endEntityIndex];
        if (startIndex <= endIndex) {
            return startIndex <= middleIndex && middleIndex <= endIndex;
        }
        return middleIndex >= startIndex || middleIndex <= endIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EntityOrderInfo)) return false;
        EntityOrderInfo that = (EntityOrderInfo)o;
        if (!Arrays.equals(this.entities, that.entities)) return false;
        if (!Objects.equals(this.entityToEntityIndex, that.entityToEntityIndex)) return false;
        if (!Arrays.equals(this.offsets, that.offsets)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.entityToEntityIndex);
        result = 31 * result + Arrays.hashCode(this.entities);
        result = 31 * result + Arrays.hashCode(this.offsets);
        return result;
    }

    @Override
    public String toString() {
        return "EntityOrderInfo{entities=" + Arrays.toString(this.entities) + ", entityToEntityIndex=" + String.valueOf(this.entityToEntityIndex) + ", offsets=" + Arrays.toString(this.offsets) + "}";
    }
}

