/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.score.descriptor;

import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.buildin.simple.SimpleScore;
import ai.timefold.solver.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import ai.timefold.solver.core.api.score.buildin.simplelong.SimpleLongScore;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.BendableScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.HardSoftScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleLongScoreDefinition;
import ai.timefold.solver.core.impl.score.buildin.SimpleScoreDefinition;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.lang.reflect.Member;
import java.util.Objects;

public class ScoreDescriptor<Score_ extends Score<Score_>> {
    @PlanningScore
    private static final Object PLANNING_SCORE = new Object();
    private final MemberAccessor scoreMemberAccessor;
    private final ScoreDefinition<Score_> scoreDefinition;

    private ScoreDescriptor(MemberAccessor scoreMemberAccessor, ScoreDefinition<Score_> scoreDefinition) {
        this.scoreMemberAccessor = scoreMemberAccessor;
        this.scoreDefinition = scoreDefinition;
    }

    public static <Score_ extends Score<Score_>> ScoreDescriptor<Score_> buildScoreDescriptor(DescriptorPolicy descriptorPolicy, Member member, Class<?> solutionClass) {
        MemberAccessor scoreMemberAccessor = ScoreDescriptor.buildScoreMemberAccessor(descriptorPolicy, member);
        Class<Score_> scoreType = ScoreDescriptor.extractScoreType(scoreMemberAccessor, solutionClass);
        PlanningScore annotation = ScoreDescriptor.extractPlanningScoreAnnotation(scoreMemberAccessor);
        Object scoreDefinition = ScoreDescriptor.buildScoreDefinition(solutionClass, scoreMemberAccessor, scoreType, annotation);
        return new ScoreDescriptor<Score_>(scoreMemberAccessor, scoreDefinition);
    }

    private static MemberAccessor buildScoreMemberAccessor(DescriptorPolicy descriptorPolicy, Member member) {
        return descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, PlanningScore.class, descriptorPolicy.getDomainAccessType());
    }

    private static <Score_ extends Score<Score_>> Class<Score_> extractScoreType(MemberAccessor scoreMemberAccessor, Class<?> solutionClass) {
        Class<?> memberType = scoreMemberAccessor.getType();
        if (!Score.class.isAssignableFrom(memberType)) {
            throw new IllegalStateException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that does not return a subtype of Score.");
        }
        if (memberType == Score.class) {
            throw new IllegalStateException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that doesn't return a non-abstract " + Score.class.getSimpleName() + " class.\nMaybe make it return " + HardSoftScore.class.getSimpleName() + " or another specific " + Score.class.getSimpleName() + " implementation.");
        }
        return memberType;
    }

    private static PlanningScore extractPlanningScoreAnnotation(MemberAccessor scoreMemberAccessor) {
        PlanningScore annotation = scoreMemberAccessor.getAnnotation(PlanningScore.class);
        if (annotation != null) {
            return annotation;
        }
        try {
            return ScoreDescriptor.class.getDeclaredField("PLANNING_SCORE").getAnnotation(PlanningScore.class);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Impossible situation: the field (PLANNING_SCORE) must exist.", e);
        }
    }

    private static <Score_ extends Score<Score_>, ScoreDefinition_ extends ScoreDefinition<Score_>> ScoreDefinition_ buildScoreDefinition(Class<?> solutionClass, MemberAccessor scoreMemberAccessor, Class<Score_> scoreType, PlanningScore annotation) {
        Class<? extends ScoreDefinition> scoreDefinitionClass = annotation.scoreDefinitionClass();
        int bendableHardLevelsSize = annotation.bendableHardLevelsSize();
        int bendableSoftLevelsSize = annotation.bendableSoftLevelsSize();
        if (!Objects.equals(scoreDefinitionClass, PlanningScore.NullScoreDefinition.class)) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that has a scoreDefinition (" + String.valueOf(scoreDefinitionClass) + ") that must not have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") or a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
            }
            return (ScoreDefinition_)ConfigUtils.newInstance(() -> String.valueOf(scoreMemberAccessor) + " with @" + PlanningScore.class.getSimpleName(), "scoreDefinitionClass", scoreDefinitionClass);
        }
        if (!IBendableScore.class.isAssignableFrom(scoreType)) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that returns a scoreType (" + String.valueOf(scoreType) + ") that must not have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") or a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
            }
            if (scoreType.equals(SimpleScore.class)) {
                return (ScoreDefinition_)new SimpleScoreDefinition();
            }
            if (scoreType.equals(SimpleLongScore.class)) {
                return (ScoreDefinition_)new SimpleLongScoreDefinition();
            }
            if (scoreType.equals(SimpleBigDecimalScore.class)) {
                return (ScoreDefinition_)new SimpleBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardSoftScore.class)) {
                return (ScoreDefinition_)new HardSoftScoreDefinition();
            }
            if (scoreType.equals(HardSoftLongScore.class)) {
                return (ScoreDefinition_)new HardSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardSoftBigDecimalScore.class)) {
                return (ScoreDefinition_)new HardSoftBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftLongScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftBigDecimalScore.class)) {
                return (ScoreDefinition_)new HardMediumSoftBigDecimalScoreDefinition();
            }
            throw new IllegalArgumentException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that returns a scoreType (" + String.valueOf(scoreType) + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the @" + PlanningScore.class.getSimpleName() + " annotation.");
        }
        if (bendableHardLevelsSize == -1 || bendableSoftLevelsSize == -1) {
            throw new IllegalArgumentException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that returns a scoreType (" + String.valueOf(scoreType) + ") that must have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") and a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
        }
        if (scoreType.equals(BendableScore.class)) {
            return (ScoreDefinition_)new BendableScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableLongScore.class)) {
            return (ScoreDefinition_)new BendableLongScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableBigDecimalScore.class)) {
            return (ScoreDefinition_)new BendableBigDecimalScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        throw new IllegalArgumentException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(scoreMemberAccessor) + ") that returns a bendable scoreType (" + String.valueOf(scoreType) + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the annotation.");
    }

    public ScoreDefinition<Score_> getScoreDefinition() {
        return this.scoreDefinition;
    }

    public Class<Score_> getScoreClass() {
        return this.scoreDefinition.getScoreClass();
    }

    public Score_ getScore(Object solution) {
        return (Score_)((Score)this.scoreMemberAccessor.executeGetter(solution));
    }

    public void setScore(Object solution, Score_ score) {
        this.scoreMemberAccessor.executeSetter(solution, score);
    }

    public void failFastOnDuplicateMember(DescriptorPolicy descriptorPolicy, Member member, Class<?> solutionClass) {
        MemberAccessor memberAccessor = ScoreDescriptor.buildScoreMemberAccessor(descriptorPolicy, member);
        if (!this.scoreMemberAccessor.getName().equals(memberAccessor.getName()) || !this.scoreMemberAccessor.getClass().equals(memberAccessor.getClass())) {
            throw new IllegalStateException("The solutionClass (" + String.valueOf(solutionClass) + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + String.valueOf(memberAccessor) + ") that is duplicated by another member (" + String.valueOf(this.scoreMemberAccessor) + ").\nMaybe the annotation is defined on both the field and its getter.");
        }
    }
}

