/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.uni;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ForEachExcludingUnassignedUniNode<Solution_, A>
extends AbstractForEachUniNode<Solution_, A> {
    private final Predicate<A> filter;

    public ForEachExcludingUnassignedUniNode(Class<A> forEachClass, Predicate<A> filter, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(forEachClass, nextNodesTupleLifecycle, outputStoreSize);
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public void insert(A a) {
        if (!this.filter.test(a)) {
            return;
        }
        super.insert(a);
    }

    @Override
    public void update(A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.get(a);
        if (tuple == null) {
            this.insert(a);
        } else if (this.filter.test(a)) {
            this.updateExisting(a, tuple);
        } else {
            this.retract(a);
        }
    }

    @Override
    public void retract(A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.remove(a);
        if (tuple == null) {
            return;
        }
        super.retractExisting(a, tuple);
    }

    @Override
    public void initialize(Solution_ workingSolution) {
        throw new UnsupportedOperationException("Impossible state: initialize() is not supported on %s.".formatted(this));
    }

    @Override
    public boolean supports(AbstractForEachUniNode.LifecycleOperation lifecycleOperation) {
        return lifecycleOperation != AbstractForEachUniNode.LifecycleOperation.INITIALIZE;
    }
}

