/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.function.Consumer;

public abstract class AbstractIndexedJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft;
    private final IndexerFactory.UniKeysExtractor<Right_> keysExtractorRight;
    private final int inputStoreIndexLeftKeys;
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightKeys;
    private final int inputStoreIndexRightEntry;
    private final Indexer<LeftTuple_> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedJoinNode(IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft, IndexerFactory<Right_> indexerFactory, int inputStoreIndexLeftKeys, int inputStoreIndexLeftEntry, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightKeys, int inputStoreIndexRightEntry, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        super(inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, nextNodesTupleLifecycle, isFiltering, outputStoreIndexLeftOutEntry, outputStoreIndexRightOutEntry);
        this.keysExtractorLeft = keysExtractorLeft;
        this.keysExtractorRight = indexerFactory.buildRightKeysExtractor();
        this.inputStoreIndexLeftKeys = inputStoreIndexLeftKeys;
        this.inputStoreIndexLeftEntry = inputStoreIndexLeftEntry;
        this.inputStoreIndexRightKeys = inputStoreIndexRightKeys;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerFactory.buildIndexer(true);
        this.indexerRight = indexerFactory.buildIndexer(false);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftKeys) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(leftTuple) + ") was already added in the tupleStore.");
        }
        Object indexKeys = this.keysExtractorLeft.apply(leftTuple);
        ElementAwareList outTupleListLeft = new ElementAwareList();
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftOutTupleList, outTupleListLeft);
        this.indexAndPropagateLeft(leftTuple, indexKeys);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Object oldIndexKeys = ((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftKeys);
        if (oldIndexKeys == null) {
            this.insertLeft(leftTuple);
            return;
        }
        Object newIndexKeys = this.keysExtractorLeft.apply(leftTuple);
        if (oldIndexKeys.equals(newIndexKeys)) {
            this.innerUpdateLeft(leftTuple, consumer -> this.indexerRight.forEach(oldIndexKeys, (Consumer<UniTuple<Right_>>)consumer));
        } else {
            ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry);
            ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
            this.indexerLeft.remove(oldIndexKeys, leftEntry);
            outTupleListLeft.forEach(this::retractOutTuple);
            this.indexAndPropagateLeft(leftTuple, newIndexKeys);
        }
    }

    private void indexAndPropagateLeft(LeftTuple_ leftTuple, Object indexKeys) {
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftKeys, indexKeys);
        ElementAwareListEntry<LeftTuple_> leftEntry = this.indexerLeft.put(indexKeys, leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftEntry, leftEntry);
        this.indexerRight.forEach(indexKeys, rightTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Object indexKeys = ((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftKeys);
        if (indexKeys == null) {
            return;
        }
        ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftEntry);
        ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftOutTupleList);
        this.indexerLeft.remove(indexKeys, leftEntry);
        outTupleListLeft.forEach(this::retractOutTuple);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightKeys) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(rightTuple) + ") was already added in the tupleStore.");
        }
        Object indexKeys = this.keysExtractorRight.apply(rightTuple);
        ElementAwareList outTupleListRight = new ElementAwareList();
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, outTupleListRight);
        this.indexAndPropagateRight(rightTuple, indexKeys);
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        Object oldIndexKeys = rightTuple.getStore(this.inputStoreIndexRightKeys);
        if (oldIndexKeys == null) {
            this.insertRight(rightTuple);
            return;
        }
        Object newIndexKeys = this.keysExtractorRight.apply(rightTuple);
        if (oldIndexKeys.equals(newIndexKeys)) {
            this.innerUpdateRight(rightTuple, consumer -> this.indexerLeft.forEach(oldIndexKeys, (Consumer<LeftTuple_>)consumer));
        } else {
            ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
            ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
            this.indexerRight.remove(oldIndexKeys, rightEntry);
            outTupleListRight.forEach(this::retractOutTuple);
            this.indexAndPropagateRight(rightTuple, newIndexKeys);
        }
    }

    private void indexAndPropagateRight(UniTuple<Right_> rightTuple, Object indexKeys) {
        rightTuple.setStore(this.inputStoreIndexRightKeys, indexKeys);
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexKeys, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        this.indexerLeft.forEach(indexKeys, leftTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        Object indexKeys = rightTuple.removeStore(this.inputStoreIndexRightKeys);
        if (indexKeys == null) {
            return;
        }
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        this.indexerRight.remove(indexKeys, rightEntry);
        outTupleListRight.forEach(this::retractOutTuple);
    }
}

